/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.api.utils.turf;

import com.mapbox.services.api.utils.turf.TurfException;
import java.util.HashMap;
import java.util.Map;

public class TurfHelpers {
    private static final Map<String, Double> factors = new HashMap<String, Double>();

    public static double radiansToDistance(double radians) throws TurfException {
        return TurfHelpers.radiansToDistance(radians, "kilometers");
    }

    public static double radiansToDistance(double radians, String units) throws TurfException {
        Double factor = factors.get(units);
        if (factor == null) {
            throw new TurfException("Invalid unit.");
        }
        return radians * factor;
    }

    public static double distanceToRadians(double distance) throws TurfException {
        return TurfHelpers.distanceToRadians(distance, "kilometers");
    }

    public static double distanceToRadians(double distance, String units) throws TurfException {
        Double factor = factors.get(units);
        if (factor == null) {
            throw new TurfException("Invalid unit.");
        }
        return distance / factor;
    }

    public static double convertDistance(double distance, String originalUnit) {
        return TurfHelpers.convertDistance(distance, originalUnit, "kilometers");
    }

    public static double convertDistance(double distance, String originalUnit, String finalUnit) {
        Double factor = factors.get(originalUnit);
        if (factor == null) {
            throw new TurfException("Invalid unit.");
        }
        if (!(distance >= 0.0)) {
            throw new TurfException("Distance must be a positive number.");
        }
        if (finalUnit == null) {
            finalUnit = "kilometers";
        }
        return TurfHelpers.radiansToDistance(TurfHelpers.distanceToRadians(distance, originalUnit), finalUnit);
    }

    static {
        factors.put("miles", 3960.0);
        factors.put("nauticalmiles", 3441.145);
        factors.put("degrees", 57.2957795);
        factors.put("radians", 1.0);
        factors.put("inches", 2.509056E8);
        factors.put("yards", 6969600.0);
        factors.put("meters", 6373000.0);
        factors.put("centimeters", 6.373E8);
        factors.put("kilometers", 6373.0);
        factors.put("feet", 2.090879265E7);
        factors.put("centimetres", 6.373E8);
        factors.put("metres", 6373000.0);
        factors.put("kilometres", 6373.0);
    }
}

