/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.api.geocoding.v5;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mapbox.services.api.MapboxBuilder;
import com.mapbox.services.api.MapboxService;
import com.mapbox.services.api.ServicesException;
import com.mapbox.services.api.geocoding.v5.GeocodingService;
import com.mapbox.services.api.geocoding.v5.gson.CarmenGeometryDeserializer;
import com.mapbox.services.api.geocoding.v5.models.GeocodingResponse;
import com.mapbox.services.commons.geojson.Geometry;
import com.mapbox.services.commons.models.Position;
import com.mapbox.services.commons.utils.TextUtils;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

public class MapboxGeocoding
extends MapboxService<GeocodingResponse> {
    protected Builder builder = null;
    private GeocodingService service = null;
    private Call<GeocodingResponse> call = null;
    private Call<List<GeocodingResponse>> batchCall = null;
    private Gson gson;

    protected MapboxGeocoding(Builder builder) {
        this.builder = builder;
    }

    protected Gson getGson() {
        if (this.gson == null) {
            this.gson = new GsonBuilder().registerTypeAdapter(Geometry.class, (Object)new CarmenGeometryDeserializer()).create();
        }
        return this.gson;
    }

    public GeocodingService getService() {
        if (this.service != null) {
            return this.service;
        }
        Retrofit.Builder retrofitBuilder = new Retrofit.Builder().baseUrl(this.builder.getBaseUrl()).addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)this.getGson()));
        if (this.getCallFactory() != null) {
            retrofitBuilder.callFactory(this.getCallFactory());
        } else {
            retrofitBuilder.client(this.getOkHttpClient());
        }
        this.service = (GeocodingService)retrofitBuilder.build().create(GeocodingService.class);
        return this.service;
    }

    public Call<GeocodingResponse> getCall() {
        if (this.call != null) {
            return this.call;
        }
        if (this.builder.getQuery().contains(";")) {
            throw new IllegalArgumentException("Use getBatchCall() for batch calls.");
        }
        this.call = this.getService().getCall(MapboxGeocoding.getHeaderUserAgent(this.builder.getClientAppName()), this.builder.getMode(), this.builder.getQuery(), this.builder.getAccessToken(), this.builder.getCountry(), this.builder.getProximity(), this.builder.getGeocodingTypes(), this.builder.getAutocomplete(), this.builder.getBbox(), this.builder.getLimit(), this.builder.getLanguages());
        return this.call;
    }

    public Call<List<GeocodingResponse>> getBatchCall() {
        if (this.batchCall != null) {
            return this.batchCall;
        }
        if (!this.builder.getQuery().contains(";")) {
            throw new IllegalArgumentException("Use getCall() for non-batch calls.");
        }
        this.batchCall = this.getService().getBatchCall(MapboxGeocoding.getHeaderUserAgent(this.builder.getClientAppName()), this.builder.getMode(), this.builder.getQuery(), this.builder.getAccessToken(), this.builder.getCountry(), this.builder.getProximity(), this.builder.getGeocodingTypes(), this.builder.getAutocomplete(), this.builder.getBbox(), this.builder.getLimit(), this.builder.getLanguages());
        return this.batchCall;
    }

    @Override
    public Response<GeocodingResponse> executeCall() throws IOException {
        return this.getCall().execute();
    }

    public Response<List<GeocodingResponse>> executeBatchCall() throws IOException {
        return this.getBatchCall().execute();
    }

    @Override
    public void enqueueCall(Callback<GeocodingResponse> callback) {
        this.getCall().enqueue(callback);
    }

    public void enqueueBatchCall(Callback<List<GeocodingResponse>> callback) {
        this.getBatchCall().enqueue(callback);
    }

    @Override
    public void cancelCall() {
        this.getCall().cancel();
    }

    public void cancelBatchCall() {
        this.getBatchCall().cancel();
    }

    @Override
    public Call<GeocodingResponse> cloneCall() {
        return this.getCall().clone();
    }

    public Call<List<GeocodingResponse>> cloneBatchCall() {
        return this.getBatchCall().clone();
    }

    public static class Builder<T extends Builder>
    extends MapboxBuilder {
        private String accessToken;
        private String query;
        private String mode = "mapbox.places";
        private String country = null;
        private String proximity = null;
        private String geocodingTypes = null;
        private Boolean autocomplete = null;
        private String bbox = null;
        private String limit = null;
        private String[] languages = null;

        public T setAccessToken(String accessToken) {
            this.accessToken = accessToken;
            return (T)this;
        }

        public T setLocation(String location) {
            this.query = location;
            return (T)this;
        }

        public T setCoordinates(Position position) {
            if (position == null) {
                return (T)this;
            }
            this.query = String.format(Locale.US, "%s,%s", TextUtils.formatCoordinate((double)position.getLongitude()), TextUtils.formatCoordinate((double)position.getLatitude()));
            return (T)this;
        }

        public T setMode(String mode) {
            this.mode = mode;
            return (T)this;
        }

        public T setCountry(String country) {
            this.country = country;
            return (T)this;
        }

        public T setCountries(String[] countries) {
            this.country = TextUtils.join((CharSequence)",", (Object[])countries);
            return (T)this;
        }

        public T setProximity(Position position) {
            if (position == null) {
                return (T)this;
            }
            this.proximity = String.format(Locale.US, "%s,%s", TextUtils.formatCoordinate((double)position.getLongitude()), TextUtils.formatCoordinate((double)position.getLatitude()));
            return (T)this;
        }

        public T setGeocodingType(String geocodingType) {
            this.geocodingTypes = geocodingType;
            return (T)this;
        }

        public T setGeocodingTypes(String[] geocodingType) {
            this.geocodingTypes = TextUtils.join((CharSequence)",", (Object[])geocodingType);
            return (T)this;
        }

        public T setAutocomplete(boolean autocomplete) {
            this.autocomplete = autocomplete;
            return (T)this;
        }

        public T setBbox(Position northeast, Position southwest) throws ServicesException {
            return this.setBbox(southwest.getLongitude(), southwest.getLatitude(), northeast.getLongitude(), northeast.getLatitude());
        }

        public T setBbox(double minX, double minY, double maxX, double maxY) throws ServicesException {
            if (minX == 0.0 && minY == 0.0 && maxX == 0.0 && maxY == 0.0) {
                throw new ServicesException("You provided an empty bounding box");
            }
            this.bbox = String.format(Locale.US, "%s,%s,%s,%s", TextUtils.formatCoordinate((double)minX), TextUtils.formatCoordinate((double)minY), TextUtils.formatCoordinate((double)maxX), TextUtils.formatCoordinate((double)maxY));
            return (T)this;
        }

        public T setLimit(int limit) {
            if (limit == 0) {
                return (T)this;
            }
            this.limit = String.format(Locale.US, "%d", limit);
            return (T)this;
        }

        @Override
        public String getAccessToken() {
            return this.accessToken;
        }

        public String getQuery() {
            return this.query;
        }

        public String getMode() {
            return this.mode;
        }

        public String getCountry() {
            return this.country;
        }

        public String getProximity() {
            return this.proximity;
        }

        public String getGeocodingTypes() {
            return this.geocodingTypes;
        }

        public Boolean getAutocomplete() {
            return this.autocomplete;
        }

        public String getBbox() {
            return this.bbox;
        }

        public String getLimit() {
            return this.limit;
        }

        public String getLanguages() {
            if (this.languages == null || this.languages.length == 0) {
                return null;
            }
            if (this.languages.length == 1) {
                return this.languages[0];
            }
            return TextUtils.join((CharSequence)",", (Object[])this.languages);
        }

        @Deprecated
        public T setLanguage(String language) {
            this.languages = new String[1];
            this.languages[0] = language;
            return (T)this;
        }

        public T setLanguages(String ... language) {
            this.languages = language;
            return (T)this;
        }

        @Override
        public T setClientAppName(String appName) {
            this.clientAppName = appName;
            return (T)this;
        }

        @Override
        public T setBaseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return (T)this;
        }

        @Override
        public MapboxGeocoding build() throws ServicesException {
            this.validateAccessToken(this.accessToken);
            return new MapboxGeocoding(this);
        }
    }
}

