/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.api.geocoding.v5.models;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.mapbox.services.api.geocoding.v5.gson.CarmenGeometryDeserializer;
import com.mapbox.services.api.geocoding.v5.models.CarmenContext;
import com.mapbox.services.commons.geojson.Feature;
import com.mapbox.services.commons.geojson.Geometry;
import com.mapbox.services.commons.geojson.custom.GeometryDeserializer;
import com.mapbox.services.commons.geojson.custom.PositionDeserializer;
import com.mapbox.services.commons.models.Position;
import java.util.List;

public class CarmenFeature
extends Feature {
    private String text;
    @SerializedName(value="place_name")
    private String placeName;
    @SerializedName(value="place_type")
    private String[] placeType;
    private double[] bbox;
    private String address;
    private double[] center;
    private List<CarmenContext> context;
    private double relevance;
    @SerializedName(value="matching_text")
    private String matchingText;
    @SerializedName(value="matching_place_name")
    private String matchingPlaceName;
    private String language;

    public CarmenFeature() {
        super(null, null, null);
    }

    private CarmenFeature(Geometry geometry, JsonObject properties, String id) {
        super(geometry, properties, id);
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getPlaceName() {
        return this.placeName;
    }

    public void setPlaceName(String placeName) {
        this.placeName = placeName;
    }

    public double[] getBbox() {
        return this.bbox;
    }

    public void setBbox(double[] bbox) {
        this.bbox = bbox;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public double[] getCenter() {
        return this.center;
    }

    public void setCenter(double[] center) {
        this.center = center;
    }

    public List<CarmenContext> getContext() {
        return this.context;
    }

    public void setContext(List<CarmenContext> context) {
        this.context = context;
    }

    public double getRelevance() {
        return this.relevance;
    }

    public void setRelevance(double relevance) {
        this.relevance = relevance;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getMatchingPlaceName() {
        return this.matchingPlaceName;
    }

    public void setMatchingPlaceName(String matchingPlaceName) {
        this.matchingPlaceName = matchingPlaceName;
    }

    public String getMatchingText() {
        return this.matchingText;
    }

    public void setMatchingText(String matchingText) {
        this.matchingText = matchingText;
    }

    public String[] getPlaceType() {
        return this.placeType;
    }

    public void setPlaceType(String[] placeType) {
        this.placeType = placeType;
    }

    public static CarmenFeature fromJson(String json) {
        GsonBuilder gson = new GsonBuilder();
        gson.registerTypeAdapter(Position.class, (Object)new PositionDeserializer());
        gson.registerTypeAdapter(Geometry.class, (Object)new GeometryDeserializer());
        gson.registerTypeAdapter(Geometry.class, (Object)new CarmenGeometryDeserializer());
        return (CarmenFeature)((Object)gson.create().fromJson(json, CarmenFeature.class));
    }

    public Position asPosition() {
        return Position.fromCoordinates((double)this.center[0], (double)this.center[1]);
    }

    public String toString() {
        return this.getPlaceName();
    }
}

