/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.api.optimizedtrips.v1;

import com.mapbox.services.api.MapboxBuilder;
import com.mapbox.services.api.MapboxService;
import com.mapbox.services.api.ServicesException;
import com.mapbox.services.api.optimizedtrips.v1.OptimizedTripsService;
import com.mapbox.services.api.optimizedtrips.v1.models.OptimizedTripsResponse;
import com.mapbox.services.commons.models.Position;
import com.mapbox.services.commons.utils.TextUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

public class MapboxOptimizedTrips
extends MapboxService<OptimizedTripsResponse> {
    protected Builder builder = null;
    private OptimizedTripsService service = null;
    private Call<OptimizedTripsResponse> call = null;

    protected MapboxOptimizedTrips(Builder builder) {
        this.builder = builder;
    }

    private OptimizedTripsService getService() {
        if (this.service != null) {
            return this.service;
        }
        Retrofit.Builder retrofitBuilder = new Retrofit.Builder().baseUrl(this.builder.getBaseUrl()).addConverterFactory((Converter.Factory)GsonConverterFactory.create());
        if (this.getCallFactory() != null) {
            retrofitBuilder.callFactory(this.getCallFactory());
        } else {
            retrofitBuilder.client(this.getOkHttpClient());
        }
        this.service = (OptimizedTripsService)retrofitBuilder.build().create(OptimizedTripsService.class);
        return this.service;
    }

    private Call<OptimizedTripsResponse> getCall() {
        if (this.call != null) {
            return this.call;
        }
        this.call = this.getService().getCall(MapboxOptimizedTrips.getHeaderUserAgent(this.builder.getClientAppName()), this.builder.getUser(), this.builder.getProfile(), this.builder.getCoordinates(), this.builder.getAccessToken(), this.builder.getRoundTrip(), this.builder.getRadiuses(), this.builder.getBearings(), this.builder.getSteps(), this.builder.getOverview(), this.builder.getGeometries(), this.builder.getAnnotation(), this.builder.getDestination(), this.builder.getSource(), this.builder.getLanguage(), this.builder.getDistributions());
        return this.call;
    }

    @Override
    public Response<OptimizedTripsResponse> executeCall() throws IOException {
        return this.getCall().execute();
    }

    @Override
    public void enqueueCall(Callback<OptimizedTripsResponse> callback) {
        this.getCall().enqueue(callback);
    }

    @Override
    public void cancelCall() {
        this.getCall().cancel();
    }

    @Override
    public Call<OptimizedTripsResponse> cloneCall() {
        return this.getCall().clone();
    }

    public static class Builder<T extends Builder>
    extends MapboxBuilder {
        private String user = "mapbox";
        private String accessToken;
        private String profile;
        private List<Position> coordinates;
        private Boolean roundTrip;
        private String source;
        private String destination;
        private String geometries = "polyline6";
        private double[] radiuses;
        private Boolean steps;
        private double[][] bearings;
        private String[] annotations;
        private String overview;
        private String language;
        private double[][] distributions;

        public T setAccessToken(String accessToken) {
            this.accessToken = accessToken;
            return (T)this;
        }

        public T setUser(String user) {
            this.user = user;
            return (T)this;
        }

        public T setProfile(String profile) {
            this.profile = profile;
            return (T)this;
        }

        public T setCoordinates(List<Position> coordinates) {
            this.coordinates = coordinates;
            return (T)this;
        }

        public T setRoundTrip(Boolean roundTrip) {
            this.roundTrip = roundTrip;
            return (T)this;
        }

        public T setSource(String source) {
            this.source = source;
            return (T)this;
        }

        public T setDestination(String destination) {
            this.destination = destination;
            return (T)this;
        }

        public T setGeometries(String geometries) {
            this.geometries = geometries;
            return (T)this;
        }

        public T setRadiuses(double[] radiuses) {
            this.radiuses = radiuses;
            return (T)this;
        }

        public T setOverview(String overview) {
            this.overview = overview;
            return (T)this;
        }

        public T setSteps(Boolean steps) {
            this.steps = steps;
            return (T)this;
        }

        public T setBearings(double[] ... bearings) {
            this.bearings = bearings;
            return (T)this;
        }

        @Deprecated
        public T setAnnotation(String ... annotation) {
            this.annotations = annotation;
            return (T)this;
        }

        public T setAnnotations(String ... annotation) {
            this.annotations = annotation;
            return (T)this;
        }

        @Override
        public T setBaseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return (T)this;
        }

        @Override
        public T setClientAppName(String appName) {
            this.clientAppName = appName;
            return (T)this;
        }

        public T setLanguage(String language) {
            this.language = language;
            return (T)this;
        }

        public T setDistributions(double[] ... distributions) {
            this.distributions = distributions;
            return (T)this;
        }

        public String getProfile() {
            return this.profile;
        }

        public Boolean getRoundTrip() {
            return this.roundTrip;
        }

        public String getSource() {
            return this.source;
        }

        public String getDestination() {
            return this.destination;
        }

        public String getCoordinates() {
            ArrayList<String> coordinatesFormatted = new ArrayList<String>();
            for (Position coordinate : this.coordinates) {
                coordinatesFormatted.add(String.format(Locale.US, "%f,%f", coordinate.getLongitude(), coordinate.getLatitude()));
            }
            return TextUtils.join((CharSequence)";", (Object[])coordinatesFormatted.toArray());
        }

        public String getGeometries() {
            return this.geometries;
        }

        public String getRadiuses() {
            if (this.radiuses == null || this.radiuses.length == 0) {
                return null;
            }
            Object[] radiusesFormatted = new String[this.radiuses.length];
            for (int i = 0; i < this.radiuses.length; ++i) {
                radiusesFormatted[i] = this.radiuses[i] == Double.POSITIVE_INFINITY ? "unlimited" : String.format(Locale.US, "%s", TextUtils.formatCoordinate((double)this.radiuses[i]));
            }
            return TextUtils.join((CharSequence)";", (Object[])radiusesFormatted);
        }

        public String getUser() {
            return this.user;
        }

        public String getOverview() {
            return this.overview;
        }

        public Boolean getSteps() {
            return this.steps;
        }

        public String getBearings() {
            if (this.bearings == null || this.bearings.length == 0) {
                return null;
            }
            Object[] bearingFormatted = new String[this.bearings.length];
            for (int i = 0; i < this.bearings.length; ++i) {
                bearingFormatted[i] = this.bearings[i].length == 0 ? "" : String.format(Locale.US, "%s,%s", TextUtils.formatCoordinate((double)this.bearings[i][0]), TextUtils.formatCoordinate((double)this.bearings[i][1]));
            }
            return TextUtils.join((CharSequence)";", (Object[])bearingFormatted);
        }

        @Deprecated
        public String[] getAnnotation() {
            return this.annotations;
        }

        public String[] getAnnotations() {
            return this.annotations;
        }

        @Override
        public String getAccessToken() {
            return this.accessToken;
        }

        public String getLanguage() {
            return this.language;
        }

        public String getDistributions() {
            if (this.distributions == null || this.distributions.length == 0) {
                return null;
            }
            Object[] distributionsFormatted = new String[this.distributions.length];
            for (int i = 0; i < this.distributions.length; ++i) {
                distributionsFormatted[i] = this.distributions[i].length == 0 ? "" : String.format(Locale.US, "%s,%s", TextUtils.formatCoordinate((double)this.distributions[i][0]), TextUtils.formatCoordinate((double)this.distributions[i][1]));
            }
            return TextUtils.join((CharSequence)";", (Object[])distributionsFormatted);
        }

        @Override
        public MapboxOptimizedTrips build() throws ServicesException {
            this.validateAccessToken(this.accessToken);
            if (this.profile == null) {
                throw new ServicesException("A profile is required for the Optimized Trips API.");
            }
            if (this.profile.equals("driving-traffic")) {
                throw new ServicesException("The driving traffic profile does not work with this API.");
            }
            if (!(this.profile.equals("cycling") || this.profile.equals("walking") || this.profile.equals("driving"))) {
                throw new ServicesException("A valid profile must be used with the Optimized Trips API.");
            }
            if (this.coordinates == null) {
                throw new ServicesException("At least two coordinates must be provided with your API request.");
            }
            if (this.coordinates.size() < 2) {
                throw new ServicesException("At least two coordinates must be provided with your API request.");
            }
            if (this.coordinates.size() > 12) {
                throw new ServicesException("Maximum of 12 coordinates are allowed for this API.");
            }
            return new MapboxOptimizedTrips(this);
        }
    }
}

