/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.api;

import com.mapbox.services.api.ServicesException;
import com.mapbox.services.commons.utils.MapboxUtils;

public abstract class MapboxBuilder {
    protected String clientAppName;
    protected String baseUrl = "https://api.mapbox.com";

    public abstract MapboxBuilder setAccessToken(String var1);

    public abstract String getAccessToken();

    public abstract <T extends MapboxBuilder> T setBaseUrl(String var1);

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public abstract <T extends MapboxBuilder> T setClientAppName(String var1);

    public String getClientAppName() {
        return this.clientAppName;
    }

    protected void validateAccessToken(String accessToken) throws ServicesException {
        if (!MapboxUtils.isAccessTokenValid((String)accessToken)) {
            throw new ServicesException("Using Mapbox Services requires setting a valid access token.");
        }
    }

    public abstract Object build() throws ServicesException;
}

