/*
 * Decompiled with CFR 0.152.
 */
package com.maxifier.mxcache;

import com.maxifier.mxcache.CacheFactory;
import com.maxifier.mxcache.CallableWithoutExceptions;
import com.maxifier.mxcache.InternalProbeFailedError;
import com.maxifier.mxcache.ProbeFailedException;
import com.maxifier.mxcache.Version;
import com.maxifier.mxcache.clean.CacheCleaner;
import com.maxifier.mxcache.impl.resource.DependencyNode;
import com.maxifier.mxcache.impl.resource.DependencyTracker;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.Callable;
import org.apache.commons.io.IOUtils;

public final class MxCache {
    private static final String VERSION = "2.2.9";
    private static final Version PROJECT_VERSION = MxCache.loadVersion();

    private MxCache() {
    }

    private static Version loadVersion() {
        String packageVersion = MxCache.class.getPackage().getImplementationVersion();
        if (packageVersion != null) {
            return new Version(packageVersion);
        }
        return MxCache.loadVersionFromFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Version loadVersionFromFile() {
        Version version;
        InputStream in = MxCache.class.getResourceAsStream("mxcache-version");
        try {
            version = new Version(IOUtils.toString((InputStream)in));
        }
        catch (Throwable throwable) {
            try {
                IOUtils.closeQuietly((InputStream)in);
                throw throwable;
            }
            catch (IOException e) {
                return Version.UNKNOWN;
            }
        }
        IOUtils.closeQuietly((InputStream)in);
        return version;
    }

    public static String getCompatibleVersion() {
        return VERSION;
    }

    public static Version getVersionObject() {
        return PROJECT_VERSION;
    }

    public static String getVersion() {
        return PROJECT_VERSION.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean probe(Runnable task) {
        DependencyNode prevNode = DependencyTracker.track(DependencyTracker.PROBE_NODE);
        try {
            task.run();
            boolean bl = true;
            return bl;
        }
        catch (InternalProbeFailedError e) {
            boolean bl = false;
            return bl;
        }
        finally {
            DependencyTracker.exit(prevNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean withoutCache(Runnable task) {
        DependencyNode prevNode = DependencyTracker.track(DependencyTracker.NOCACHE_NODE);
        try {
            task.run();
            boolean bl = true;
            return bl;
        }
        finally {
            DependencyTracker.exit(prevNode);
        }
    }

    public static <T> T probe(Callable<T> task) throws ProbeFailedException {
        DependencyNode prevNode = DependencyTracker.track(DependencyTracker.PROBE_NODE);
        try {
            T t = task.call();
            return t;
        }
        catch (InternalProbeFailedError e) {
            throw new ProbeFailedException(e);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            DependencyTracker.exit(prevNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T hideCallerDependencies(CallableWithoutExceptions<T> callable) {
        DependencyNode node = DependencyTracker.track(DependencyTracker.HIDDEN_CALLER_NODE);
        try {
            T t = callable.call();
            return t;
        }
        finally {
            DependencyTracker.exit(node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T hideCallerDependencies(Callable<T> callable) throws Exception {
        DependencyNode node = DependencyTracker.track(DependencyTracker.HIDDEN_CALLER_NODE);
        try {
            T t = callable.call();
            return t;
        }
        finally {
            DependencyTracker.exit(node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void hideCallerDependencies(Runnable runnable) {
        DependencyNode node = DependencyTracker.track(DependencyTracker.HIDDEN_CALLER_NODE);
        try {
            runnable.run();
        }
        finally {
            DependencyTracker.exit(node);
        }
    }

    public static CacheCleaner getCleaner() {
        return CacheFactory.getCleaner();
    }
}

