/*
 * Decompiled with CFR 0.152.
 */
package com.maxifier.mxcache.clean;

import com.maxifier.mxcache.caches.Cache;
import com.maxifier.mxcache.caches.CleaningNode;
import com.maxifier.mxcache.clean.ClassCacheIds;
import com.maxifier.mxcache.clean.Cleanable;
import com.maxifier.mxcache.clean.CleanableInstanceList;
import com.maxifier.mxcache.clean.CleaningHelper;
import com.maxifier.mxcache.clean.WeakList;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nullable;

final class ClassCleanableInstanceList<T>
extends WeakList<T>
implements CleanableInstanceList {
    private final ClassCleanableInstanceList<? super T> parent;
    private final List<ClassCleanableInstanceList<? extends T>> children;
    private final Class clazz;
    private final Cleanable<T> cleanable;
    private final Map<String, ClassCacheIds> groups;
    private final Map<String, ClassCacheIds> tags;
    private final Lock readLock;
    private final Lock writeLock;
    private volatile int version;

    public ClassCleanableInstanceList(@Nullable ClassCleanableInstanceList<? super T> parent, Cleanable<T> cleanable, Map<String, ClassCacheIds> groups, Map<String, ClassCacheIds> tags, Class clazz) {
        this.parent = parent;
        this.tags = tags;
        this.groups = groups;
        this.clazz = clazz;
        this.children = new ArrayList<ClassCleanableInstanceList<? extends T>>();
        this.cleanable = cleanable;
        if (parent != null) {
            parent.addChild(this);
        }
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.readLock = lock.readLock();
        this.writeLock = lock.writeLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addChild(ClassCleanableInstanceList<? extends T> child) {
        this.writeLock.lock();
        try {
            ++this.version;
            this.children.add(child);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public int deepLock() {
        this.readLock.lock();
        int version = this.version;
        for (ClassCleanableInstanceList<T> child : this.children) {
            version += child.deepLock();
        }
        return version;
    }

    @Override
    public void deepUnlock() {
        for (ClassCleanableInstanceList<T> child : this.children) {
            child.deepUnlock();
        }
        this.readLock.unlock();
    }

    @Override
    public void getLists(List<WeakList<?>> lists) {
        lists.add(this);
        for (ClassCleanableInstanceList<T> child : this.children) {
            child.getLists(lists);
        }
    }

    @Override
    public void getCaches(List<CleaningNode> caches) {
        ClassCleanableInstanceList<? super T> list = this.parent;
        while (list != null) {
            for (Object t : this) {
                list.cleanable.appendInstanceCachesTo(caches, t);
            }
            list = list.parent;
        }
        this.getCachesHierarchically(caches);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getCachesHierarchically(List<CleaningNode> caches) {
        this.cleanable.appendStaticCachesTo(caches);
        for (Object t : this) {
            this.cleanable.appendInstanceCachesTo(caches, t);
        }
        this.readLock.lock();
        try {
            for (ClassCleanableInstanceList classCleanableInstanceList : this.children) {
                classCleanableInstanceList.getCachesHierarchically(caches);
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void clearCache() {
        CleaningHelper.clear(this);
    }

    public void clearCacheByGroup(Object o, String group) {
        Object t = o;
        CleaningHelper.lockAndClear(this.getGroupInstanceCaches(group, t));
    }

    public void clearCacheByTag(Object o, String tag) {
        Object t = o;
        CleaningHelper.lockAndClear(this.getTagInstanceCaches(tag, t));
    }

    private List<Cache> getTagInstanceCaches(String tag, Object t) {
        ArrayList<Cache> caches = new ArrayList<Cache>();
        ClassCleanableInstanceList<T> classList = this;
        while (classList != null) {
            classList.appendTagInstanceCaches(tag, t, caches);
            classList = classList.parent;
        }
        return caches;
    }

    private void appendTagInstanceCaches(String tag, Object t, List<Cache> caches) {
        ClassCacheIds ids;
        if (this.tags != null && (ids = this.tags.get(tag)) != null) {
            ids.appendInstanceCaches(this.cleanable, t, caches);
        }
    }

    private List<Cache> getGroupInstanceCaches(String tag, Object t) {
        ArrayList<Cache> caches = new ArrayList<Cache>();
        ClassCleanableInstanceList<T> classList = this;
        while (classList != null) {
            classList.appendGroupInstanceCaches(tag, t, caches);
            classList = classList.parent;
        }
        return caches;
    }

    private void appendGroupInstanceCaches(String tag, Object t, List<Cache> caches) {
        ClassCacheIds ids;
        if (this.groups != null && (ids = this.groups.get(tag)) != null) {
            ids.appendInstanceCaches(this.cleanable, t, caches);
        }
    }

    public void clearCache(Object o) {
        Object t = o;
        CleaningHelper.lockAndClear(this.getInstanceCaches(t));
    }

    private List<CleaningNode> getInstanceCaches(T t) {
        ArrayList<CleaningNode> caches = new ArrayList<CleaningNode>();
        ClassCleanableInstanceList<? super T> classList = this;
        while (classList != null) {
            classList.cleanable.appendInstanceCachesTo(caches, t);
            classList = classList.parent;
        }
        return caches;
    }

    public Cleanable<T> getCleanable() {
        return this.cleanable;
    }

    public String toString() {
        return "ClassCleanableInstanceList[" + this.clazz + "]";
    }
}

