/*
 * Decompiled with CFR 0.152.
 */
package com.maxifier.mxcache.clean;

import com.maxifier.mxcache.caches.CleaningNode;
import com.maxifier.mxcache.clean.CleanableInstanceList;
import com.maxifier.mxcache.clean.MappingIterable;
import com.maxifier.mxcache.clean.SuperLock;
import com.maxifier.mxcache.clean.WeakList;
import com.maxifier.mxcache.impl.resource.DependencyNode;
import com.maxifier.mxcache.impl.resource.DependencyTracker;
import com.maxifier.mxcache.util.TIdentityHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.Lock;
import javax.annotation.Nonnull;

public final class CleaningHelper {
    private CleaningHelper() {
    }

    private static SuperLock getSuperLock(Collection<? extends CleaningNode> caches) {
        ArrayList<Lock> locks = new ArrayList<Lock>(caches.size());
        for (CleaningNode cleaningNode : caches) {
            Lock lock = cleaningNode.getLock();
            if (lock == null) continue;
            locks.add(lock);
        }
        return new SuperLock(locks);
    }

    private static int lockLists(List<WeakList<?>> lists) {
        int version = 0;
        for (WeakList<?> list : lists) {
            version += list.lock();
        }
        return version;
    }

    private static void unlockLists(List<WeakList<?>> lists) {
        for (WeakList<?> list : lists) {
            list.unlock();
        }
    }

    private static void clear(Collection<? extends CleaningNode> caches) {
        for (CleaningNode cleaningNode : caches) {
            cleaningNode.clear();
        }
    }

    /*
     * Exception decompiling
     */
    public static void clear(@Nonnull CleanableInstanceList list) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static RecursiveLock lockRecursive(DependencyNode rootNode) {
        TIdentityHashSet<CleaningNode> elements = DependencyTracker.getAllDependentNodes(Collections.singleton(rootNode));
        Iterable<DependencyNode> nodes = CleaningHelper.nodeMapping(elements);
        while (true) {
            SuperLock superLock = CleaningHelper.getSuperLock(elements);
            superLock.lock();
            try {
                TIdentityHashSet<CleaningNode> newElements = DependencyTracker.getAllDependentNodes(nodes, elements);
                if (newElements.containsAll((Collection)((Object)elements))) {
                    return new RecursiveLock(elements, superLock);
                }
                superLock.unlock();
                elements.addAll((Collection)((Object)newElements));
            }
            catch (Error e) {
                superLock.unlock();
                throw e;
            }
            catch (RuntimeException e) {
                superLock.unlock();
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void lockAndClear(Collection<? extends CleaningNode> elements) {
        Iterable<DependencyNode> nodes = CleaningHelper.nodeMapping(elements);
        TIdentityHashSet<CleaningNode> elementsAndDependent = DependencyTracker.getAllDependentNodes(nodes, elements);
        while (true) {
            SuperLock superLock = CleaningHelper.getSuperLock(elementsAndDependent);
            superLock.lock();
            try {
                TIdentityHashSet<CleaningNode> newElements = DependencyTracker.getAllDependentNodes(nodes, elements);
                if (newElements.equals(elementsAndDependent)) {
                    Iterator i$ = elementsAndDependent.iterator();
                    while (i$.hasNext()) {
                        CleaningNode element = (CleaningNode)i$.next();
                        element.clear();
                    }
                    return;
                }
                elementsAndDependent = newElements;
                continue;
            }
            finally {
                superLock.unlock();
                continue;
            }
            break;
        }
    }

    private static Iterable<DependencyNode> nodeMapping(Collection<? extends CleaningNode> elements) {
        return new MappingIterable<CleaningNode, DependencyNode>(elements){

            @Override
            public DependencyNode map(CleaningNode cleaningNode) {
                return cleaningNode.getDependencyNode();
            }
        };
    }

    public static class RecursiveLock {
        public final TIdentityHashSet<CleaningNode> elements;
        public final SuperLock lock;

        public RecursiveLock(TIdentityHashSet<CleaningNode> elements, SuperLock lock) {
            this.elements = elements;
            this.lock = lock;
        }
    }
}

