/*
 * Decompiled with CFR 0.152.
 */
package com.maxifier.mxcache.config;

import java.util.Set;
import javax.xml.bind.annotation.XmlElement;

class Selector {
    @XmlElement(name="class")
    private String className;
    @XmlElement
    private String group;
    @XmlElement(name="tag")
    private Set<String> tags;
    @XmlElement(name="annotated")
    private Set<String> annotations;

    Selector() {
    }

    public boolean matches(Class className, String group, String[] tags) {
        return this.matchClassName(className) && this.matchGroup(group) && this.matchTagsAndAnnotations(tags);
    }

    private boolean matchTagsAndAnnotations(String[] tags) {
        int matchedTagCount = 0;
        int matchedAnnotationCount = 0;
        if (tags != null) {
            for (String tag : tags) {
                if (Selector.isAnnotationTag(tag)) {
                    if (!this.hasAnnotation(tag.substring(1))) continue;
                    ++matchedAnnotationCount;
                    continue;
                }
                if (!this.hasTag(tag)) continue;
                ++matchedTagCount;
            }
        }
        return this.isAllAnnotationsMatched(matchedAnnotationCount) && this.isAllTagsMatched(matchedTagCount);
    }

    private boolean isAllTagsMatched(int matchedTagCount) {
        return this.tags == null || matchedTagCount == this.tags.size();
    }

    private boolean isAllAnnotationsMatched(int matchedAnnotationCount) {
        return this.annotations == null || matchedAnnotationCount == this.annotations.size();
    }

    private boolean hasTag(String tag) {
        return this.tags != null && this.tags.contains(tag);
    }

    private boolean hasAnnotation(String annotation) {
        return this.annotations != null && this.annotations.contains(annotation);
    }

    private static boolean isAnnotationTag(String tag) {
        return tag.charAt(0) == '@';
    }

    private boolean matchGroup(String group) {
        if (this.group != null && !this.group.equals(group)) {
            if (this.group.endsWith("*")) {
                String groupStart = this.group.substring(0, this.group.length() - 1);
                if (!group.startsWith(groupStart)) {
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    private boolean matchClassName(Class className) {
        if (this.className != null) {
            if (this.className.endsWith("*")) {
                String classNameStart = this.className.substring(0, this.className.length() - 1);
                if (!className.getCanonicalName().startsWith(classNameStart)) {
                    return false;
                }
            } else if (!this.className.equals(className.getCanonicalName())) {
                return false;
            }
        }
        return true;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        boolean start = true;
        if (this.className != null) {
            if (start) {
                start = false;
            } else {
                builder.append(", ");
            }
            builder.append("class:").append(this.className);
        }
        if (this.group != null) {
            if (start) {
                start = false;
            } else {
                builder.append(", ");
            }
            builder.append("group:").append(this.group);
        }
        if (this.tags != null && !this.tags.isEmpty()) {
            for (String tag : this.tags) {
                if (start) {
                    start = false;
                } else {
                    builder.append(", ");
                }
                builder.append("tag:").append(tag);
            }
        }
        if (this.annotations != null && !this.annotations.isEmpty()) {
            for (String annotation : this.annotations) {
                if (start) {
                    start = false;
                } else {
                    builder.append(", ");
                }
                builder.append("@").append(annotation);
            }
        }
        return builder.toString();
    }
}

