/*
 * Decompiled with CFR 0.152.
 */
package com.maxifier.mxcache.impl;

import com.maxifier.mxcache.DependencyTracking;
import com.maxifier.mxcache.StatisticsModeEnum;
import com.maxifier.mxcache.caches.Cache;
import com.maxifier.mxcache.context.CacheContext;
import com.maxifier.mxcache.impl.MutableStatistics;
import com.maxifier.mxcache.impl.MutableStatisticsImpl;
import com.maxifier.mxcache.impl.ProxyingCacheGenerator;
import com.maxifier.mxcache.impl.resource.AbstractDependencyNode;
import com.maxifier.mxcache.impl.resource.DependencyNode;
import com.maxifier.mxcache.impl.resource.DependencyTracker;
import com.maxifier.mxcache.impl.resource.MxResourceFactory;
import com.maxifier.mxcache.impl.wrapping.Wrapping;
import com.maxifier.mxcache.provider.CacheDescriptor;
import com.maxifier.mxcache.provider.CacheManager;
import com.maxifier.mxcache.resource.MxResource;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class AbstractCacheManager<T>
implements CacheManager<T> {
    private static final DependencyTracking DEFAULT_DEPENDENCY_TRACKING_VALUE = DependencyTracking.INSTANCE;
    private static final StatisticsModeEnum DEFAULT_STATISTICS_MODE = StatisticsModeEnum.STATIC_OR_STORAGE;
    private final CacheDescriptor<T> descriptor;
    private final DependencyNode staticNode;
    private final DependencyTracking trackDependency;
    private final MxResource[] resourceDependencies;
    private final CacheContext context;
    private final StatisticsModeEnum statisticsMode;
    private final MutableStatistics staticStatistics;

    public AbstractCacheManager(CacheContext context, CacheDescriptor<T> descriptor) {
        this.descriptor = descriptor;
        this.context = context;
        this.statisticsMode = descriptor.getStatisticsMode() == null ? DEFAULT_STATISTICS_MODE : descriptor.getStatisticsMode();
        switch (this.statisticsMode) {
            case STATIC: 
            case STATIC_OR_STORAGE: {
                this.staticStatistics = new MutableStatisticsImpl();
                break;
            }
            case INSTANCE: 
            case STORAGE: {
                this.staticStatistics = null;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown statistics mode: " + (Object)((Object)this.statisticsMode));
            }
        }
        this.trackDependency = this.convertStatic(AbstractCacheManager.convertDefault(descriptor.getTrackDependency()));
        this.resourceDependencies = this.getResources(descriptor.getResourceDependencies());
        switch (this.trackDependency) {
            case NONE: {
                if (this.resourceDependencies == null) {
                    this.staticNode = null;
                    break;
                }
                this.staticNode = this.createStaticNode();
                break;
            }
            case STATIC: {
                this.staticNode = this.createStaticNode();
                break;
            }
            case INSTANCE: {
                this.staticNode = null;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown value: " + (Object)((Object)this.trackDependency));
            }
        }
    }

    private MxResource[] getResources(Set<String> resourceNames) {
        if (resourceNames == null || resourceNames.isEmpty()) {
            return null;
        }
        MxResource[] res = new MxResource[resourceNames.size()];
        int i = 0;
        for (String resourceName : resourceNames) {
            res[i++] = MxResourceFactory.getResource(resourceName);
        }
        return res;
    }

    protected StatisticsModeEnum getStatisticsMode() {
        return this.statisticsMode;
    }

    protected DependencyNode createStaticNode() {
        AbstractDependencyNode node = this.descriptor.isStatic() ? Wrapping.getSingletonNode(this.descriptor) : Wrapping.getMultipleNode(this.descriptor);
        this.registerExplicitDependencies(node);
        return node;
    }

    protected DependencyNode createInstanceNode() {
        AbstractDependencyNode node = Wrapping.getSingletonNode(this.descriptor);
        this.registerExplicitDependencies(node);
        return node;
    }

    private DependencyTracking convertStatic(DependencyTracking tracking) {
        if (this.descriptor.isStatic() && tracking == DependencyTracking.INSTANCE) {
            return DependencyTracking.STATIC;
        }
        return tracking;
    }

    private static DependencyTracking convertDefault(DependencyTracking tracking) {
        return tracking == DependencyTracking.DEFAULT ? DEFAULT_DEPENDENCY_TRACKING_VALUE : tracking;
    }

    protected void registerExplicitDependencies(DependencyNode node) {
        if (this.resourceDependencies != null) {
            for (MxResource resourceId : this.resourceDependencies) {
                DependencyTracker.addExplicitDependency(node, resourceId);
            }
        }
    }

    @Override
    public Cache createCache(@Nullable T owner) {
        if (this.descriptor.isStatic()) {
            if (owner != null) {
                throw new IllegalArgumentException("Static cache " + this + " requires no instance");
            }
        } else if (owner == null) {
            throw new IllegalArgumentException("Non-static cache " + this + " requires instance");
        }
        try {
            DependencyNode dependencyNode = this.getDependencyNode();
            Cache instance = this.createCache(owner, this.trackDependency == DependencyTracking.NONE ? DependencyTracker.DUMMY_NODE : dependencyNode, this.createStatistics());
            if (dependencyNode != null) {
                dependencyNode.addNode(instance);
            }
            return ProxyingCacheGenerator.wrapCacheWithProxy(this.descriptor, this.context, instance);
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot create cache", e);
        }
    }

    private MutableStatistics createStatistics() {
        switch (this.statisticsMode) {
            case STATIC: 
            case STATIC_OR_STORAGE: {
                return this.staticStatistics;
            }
            case INSTANCE: {
                return new MutableStatisticsImpl();
            }
            case STORAGE: {
                return null;
            }
        }
        throw new UnsupportedOperationException("Unsupported statistics mode: " + (Object)((Object)this.statisticsMode));
    }

    private DependencyNode getDependencyNode() {
        switch (this.trackDependency) {
            case NONE: 
            case STATIC: {
                return this.staticNode;
            }
            case INSTANCE: {
                return this.createInstanceNode();
            }
        }
        throw new UnsupportedOperationException("Unknown value: " + (Object)((Object)this.trackDependency));
    }

    @Nonnull
    protected abstract Cache createCache(T var1, DependencyNode var2, MutableStatistics var3) throws Exception;

    @Override
    public CacheDescriptor<T> getDescriptor() {
        return this.descriptor;
    }

    public String toString() {
        return this.descriptor.toString();
    }

    @Override
    public CacheContext getContext() {
        return this.context;
    }
}

