/*
 * Decompiled with CFR 0.152.
 */
package com.maxifier.mxcache.impl;

import com.maxifier.mxcache.NoSuchInstanceException;
import com.maxifier.mxcache.UseStorage;
import com.maxifier.mxcache.UseStorageFactory;
import com.maxifier.mxcache.caches.Cache;
import com.maxifier.mxcache.context.CacheContext;
import com.maxifier.mxcache.impl.CustomStorageFactory;
import com.maxifier.mxcache.impl.DefaultStrategy;
import com.maxifier.mxcache.impl.NullCacheManager;
import com.maxifier.mxcache.impl.StorageBasedCacheManager;
import com.maxifier.mxcache.provider.AnnotationProperty;
import com.maxifier.mxcache.provider.CacheDescriptor;
import com.maxifier.mxcache.provider.CacheManager;
import com.maxifier.mxcache.provider.CachingStrategy;
import com.maxifier.mxcache.provider.StorageFactory;
import com.maxifier.mxcache.provider.StrategyProperty;
import com.maxifier.mxcache.storage.Storage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.WeakHashMap;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RegistryEntry<T>
implements CacheContext.ContextRelatedItem<CacheManager<T>> {
    private static final Logger logger = LoggerFactory.getLogger(RegistryEntry.class);
    private static final StrategyProperty<Class> STORAGE_FACTORY_PROPERTY = new AnnotationProperty<UseStorageFactory, Class>("storage.factory", Class.class, UseStorageFactory.class){

        @Override
        public Class getFromAnnotation(@Nonnull UseStorageFactory annotation) {
            return annotation.value();
        }
    };
    private static final StrategyProperty<Class> STORAGE_PROPERTY = new AnnotationProperty<UseStorage, Class>("storage", Class.class, UseStorage.class){

        @Override
        public Class getFromAnnotation(@Nonnull UseStorage annotation) {
            return annotation.value();
        }
    };
    private final CacheDescriptor<T> descriptor;
    private final CacheManager<T> nullCacheManager;
    private final WeakHashMap<CacheContext, Void> relatedContexts;

    public RegistryEntry(CacheDescriptor<T> descriptor) {
        this.descriptor = descriptor;
        if (descriptor.isDisabled()) {
            this.nullCacheManager = new NullCacheManager<T>(descriptor);
            this.relatedContexts = null;
        } else {
            this.nullCacheManager = null;
            this.relatedContexts = new WeakHashMap();
        }
    }

    private CachingStrategy getStrategyInstance(CacheContext context, Class<? extends CachingStrategy> strategy) {
        if (strategy == null || strategy == DefaultStrategy.class) {
            return DefaultStrategy.getInstance();
        }
        try {
            return context.getInstanceProvider().forClass(strategy);
        }
        catch (NoSuchInstanceException e) {
            logger.error("Cannot acquire instance of " + strategy, (Throwable)e);
            return DefaultStrategy.getInstance();
        }
    }

    public synchronized Collection<CacheManager<T>> getManagers() {
        if (this.relatedContexts == null) {
            return Collections.emptySet();
        }
        ArrayList<CacheManager> managers = new ArrayList<CacheManager>();
        for (CacheContext context : this.relatedContexts.keySet()) {
            CacheManager manager = (CacheManager)context.getRelated(this);
            if (manager == null) continue;
            managers.add(manager);
        }
        return Collections.unmodifiableCollection(managers);
    }

    private synchronized CacheManager<T> getManager(CacheContext context) {
        if (this.nullCacheManager != null) {
            return this.nullCacheManager;
        }
        this.relatedContexts.put(context, null);
        CacheManager<T> manager = (CacheManager<T>)context.getRelated(this);
        if (manager == null) {
            try {
                manager = this.createManager(context);
                context.setRelated(this, manager);
            }
            catch (Exception e) {
                logger.error("Cannot instantiate cache for " + this.descriptor + ", will use default", (Throwable)e);
                return DefaultStrategy.getInstance().getManager(context, this.descriptor);
            }
        }
        return manager;
    }

    public Cache createCache(CacheContext context, T instance) {
        try {
            return this.getManager(context).createCache(instance);
        }
        catch (RuntimeException e) {
            logger.error("Cannot create cache for " + instance + ", DefaultStrategy will be used", (Throwable)e);
            return DefaultStrategy.getInstance().getManager(context, this.descriptor).createCache(instance);
        }
    }

    private void checkTooManyStrategies(Class<StorageFactory<T>> storageFactoryClass, Class<Storage> storageClass, Class<? extends CachingStrategy> strategyClass) {
        int n = 0;
        StringBuilder message = new StringBuilder();
        if (storageFactoryClass != null) {
            message.append("storageFactory = ").append(storageFactoryClass);
            ++n;
        }
        if (storageClass != null) {
            if (n != 0) {
                message.append(", ");
            }
            message.append("storage = ").append(storageClass);
            ++n;
        }
        if (strategyClass != null) {
            if (n != 0) {
                message.append(", ");
            }
            message.append("strategy = ").append(strategyClass);
            ++n;
        }
        if (n > 1) {
            logger.error("Too many strategy assignments: " + message + " at " + this.descriptor);
        }
    }

    private CacheManager<T> createManager(CacheContext context) {
        CacheManager<T> manager;
        Class storageFactoryClass = this.descriptor.getProperty(STORAGE_FACTORY_PROPERTY);
        Class storageClass = this.descriptor.getProperty(STORAGE_PROPERTY);
        Class<CachingStrategy> strategyClass = this.descriptor.getStrategyClass();
        this.checkTooManyStrategies(storageFactoryClass, storageClass, strategyClass);
        if (storageFactoryClass != null) {
            return new StorageBasedCacheManager<T>(context, this.descriptor, DefaultStrategy.getInstance().getStorageFactory(context, this.descriptor, storageFactoryClass));
        }
        if (storageClass != null) {
            return new StorageBasedCacheManager<T>(context, this.descriptor, new CustomStorageFactory<T>(context, this.descriptor, storageClass));
        }
        if (strategyClass == null) {
            strategyClass = DefaultStrategy.class;
        }
        CachingStrategy strategy = this.getStrategyInstance(context, strategyClass);
        try {
            manager = strategy.getManager(context, this.descriptor);
        }
        catch (RuntimeException e) {
            logger.error("Strategy failed: " + strategy + ", will try default strategy", (Throwable)e);
            return DefaultStrategy.getInstance().getManager(context, this.descriptor);
        }
        if (manager == null) {
            logger.error("Strategy failed: " + strategy + " returned null manager");
            return DefaultStrategy.getInstance().getManager(context, this.descriptor);
        }
        return manager;
    }

    public CacheDescriptor<T> getDescriptor() {
        return this.descriptor;
    }

    public String toString() {
        return "RegistryEntry{descriptor=" + this.descriptor + ", managers=" + (this.nullCacheManager == null ? this.getManagers() : this.nullCacheManager) + '}';
    }
}

