/*
 * Decompiled with CFR 0.152.
 */
package com.maxifier.mxcache.impl.caches.abs;

import com.maxifier.mxcache.CacheFactory;
import com.maxifier.mxcache.caches.BooleanCache;
import com.maxifier.mxcache.caches.BooleanCalculatable;
import com.maxifier.mxcache.impl.CacheId;
import com.maxifier.mxcache.impl.CalculatableHelper;
import com.maxifier.mxcache.impl.MutableStatistics;
import com.maxifier.mxcache.impl.caches.abs.AbstractCache;
import com.maxifier.mxcache.impl.resource.DependencyNode;
import com.maxifier.mxcache.impl.resource.DependencyTracker;
import com.maxifier.mxcache.impl.resource.ResourceOccupied;
import com.maxifier.mxcache.provider.CacheDescriptor;
import com.maxifier.mxcache.storage.BooleanStorage;

public abstract class AbstractBooleanCache
extends AbstractCache
implements BooleanCache,
BooleanStorage {
    private final BooleanCalculatable calculatable;

    public AbstractBooleanCache(Object owner, BooleanCalculatable calculatable, MutableStatistics statistics) {
        super(owner, statistics);
        this.calculatable = calculatable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public boolean getOrCreate() {
        if (DependencyTracker.isBypassCaches()) {
            return this.calculatable.calculate(this.owner);
        }
        this.lock();
        try {
            if (this.isCalculated()) {
                DependencyTracker.mark(this.getDependencyNode());
                this.hit();
                boolean bl = this.load();
                return bl;
            }
            DependencyNode callerNode = DependencyTracker.track(this.getDependencyNode());
            while (true) {
                boolean bl;
                try {
                    bl = this.create();
                }
                catch (ResourceOccupied e) {
                    block19: {
                        if (callerNode != null) {
                            throw e;
                        }
                        this.unlock();
                        try {
                            e.getResource().waitForEndOfModification();
                        }
                        finally {
                            this.lock();
                        }
                        if (!this.isCalculated()) break block19;
                        this.hit();
                        boolean bl2 = this.load();
                        DependencyTracker.exit(callerNode);
                        this.unlock();
                        return bl2;
                    }
                    continue;
                    {
                        catch (Throwable throwable) {
                            DependencyTracker.exit(callerNode);
                            throw throwable;
                        }
                    }
                }
                DependencyTracker.exit(callerNode);
                return bl;
                break;
            }
        }
        finally {
            this.unlock();
        }
    }

    protected boolean create() {
        long start = System.nanoTime();
        boolean t = this.calculatable.calculate(this.owner);
        long end = System.nanoTime();
        this.miss(end - start);
        this.save(t);
        return t;
    }

    @Override
    public CacheDescriptor getDescriptor() {
        CacheId id = CalculatableHelper.getId(this.calculatable.getClass());
        return CacheFactory.getProvider().getDescriptor(id);
    }

    @Override
    public String toString() {
        return this.getDescriptor() + ": " + this.owner;
    }
}

