/*
 * Decompiled with CFR 0.152.
 */
package com.maxifier.mxcache.impl.caches.abs;

import com.maxifier.mxcache.CacheFactory;
import com.maxifier.mxcache.caches.ByteObjectCache;
import com.maxifier.mxcache.caches.ByteObjectCalculatable;
import com.maxifier.mxcache.impl.CacheId;
import com.maxifier.mxcache.impl.CalculatableHelper;
import com.maxifier.mxcache.impl.MutableStatistics;
import com.maxifier.mxcache.impl.caches.abs.AbstractCache;
import com.maxifier.mxcache.impl.resource.DependencyNode;
import com.maxifier.mxcache.impl.resource.DependencyTracker;
import com.maxifier.mxcache.impl.resource.ResourceOccupied;
import com.maxifier.mxcache.provider.CacheDescriptor;
import com.maxifier.mxcache.storage.ByteObjectStorage;

public abstract class AbstractByteObjectCache<F>
extends AbstractCache
implements ByteObjectCache<F>,
ByteObjectStorage<F> {
    private final ByteObjectCalculatable<F> calculatable;

    public AbstractByteObjectCache(Object owner, ByteObjectCalculatable<F> calculatable, MutableStatistics statistics) {
        super(owner, statistics);
        this.calculatable = calculatable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public F getOrCreate(byte o) {
        if (DependencyTracker.isBypassCaches()) {
            return this.calculatable.calculate(this.owner, o);
        }
        this.lock();
        try {
            Object v = this.load(o);
            if (v != UNDEFINED) {
                DependencyTracker.mark(this.getDependencyNode());
                this.hit();
                Object object = v;
                return (F)object;
            }
            DependencyNode callerNode = DependencyTracker.track(this.getDependencyNode());
            while (true) {
                F f;
                try {
                    f = this.create(o);
                }
                catch (ResourceOccupied e) {
                    block19: {
                        if (callerNode != null) {
                            throw e;
                        }
                        this.unlock();
                        try {
                            e.getResource().waitForEndOfModification();
                        }
                        finally {
                            this.lock();
                        }
                        v = this.load(o);
                        if (v == UNDEFINED) break block19;
                        this.hit();
                        Object object = v;
                        DependencyTracker.exit(callerNode);
                        this.unlock();
                        return (F)object;
                    }
                    continue;
                    {
                        catch (Throwable throwable) {
                            DependencyTracker.exit(callerNode);
                            throw throwable;
                        }
                    }
                }
                DependencyTracker.exit(callerNode);
                return f;
                break;
            }
        }
        finally {
            this.unlock();
        }
    }

    protected F create(byte o) {
        long start = System.nanoTime();
        F t = this.calculatable.calculate(this.owner, o);
        long end = System.nanoTime();
        this.miss(end - start);
        this.save(o, t);
        return t;
    }

    @Override
    public CacheDescriptor getDescriptor() {
        CacheId id = CalculatableHelper.getId(this.calculatable.getClass());
        return CacheFactory.getProvider().getDescriptor(id);
    }

    @Override
    public String toString() {
        return this.getDescriptor() + ": " + this.owner;
    }
}

