/*
 * Decompiled with CFR 0.152.
 */
package com.maxifier.mxcache.impl.caches.abs;

import com.maxifier.mxcache.LightweightLock;
import com.maxifier.mxcache.caches.Cache;
import com.maxifier.mxcache.impl.MutableStatistics;
import com.maxifier.mxcache.impl.resource.DependencyNode;
import com.maxifier.mxcache.interfaces.Statistics;
import com.maxifier.mxcache.storage.Storage;
import java.util.concurrent.locks.Lock;
import javax.annotation.Nullable;

abstract class AbstractCache
extends LightweightLock
implements Cache,
Storage {
    private final MutableStatistics statistics;
    private DependencyNode node;
    protected final Object owner;

    protected AbstractCache(Object owner, @Nullable MutableStatistics statistics) {
        this.owner = owner;
        this.statistics = statistics;
    }

    @Override
    public void setDependencyNode(DependencyNode node) {
        this.node = node;
    }

    @Override
    public Lock getLock() {
        return this;
    }

    @Override
    public Statistics getStatistics() {
        return this.statistics;
    }

    protected final void miss(long dt) {
        if (this.statistics != null) {
            this.statistics.miss(dt);
        }
    }

    protected final void hit() {
        if (this.statistics != null) {
            this.statistics.hit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getSize() {
        this.lock();
        try {
            int n = this.size();
            return n;
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public DependencyNode getDependencyNode() {
        return this.node;
    }

    @Override
    public Object getCacheOwner() {
        return this.owner;
    }
}

