/*
 * Decompiled with CFR 0.152.
 */
package com.maxifier.mxcache.impl.caches.abs;

import com.maxifier.mxcache.CacheFactory;
import com.maxifier.mxcache.caches.ObjectIntCache;
import com.maxifier.mxcache.caches.ObjectIntCalculatable;
import com.maxifier.mxcache.impl.CacheId;
import com.maxifier.mxcache.impl.CalculatableHelper;
import com.maxifier.mxcache.impl.MutableStatistics;
import com.maxifier.mxcache.impl.caches.abs.AbstractCache;
import com.maxifier.mxcache.impl.resource.DependencyNode;
import com.maxifier.mxcache.impl.resource.DependencyTracker;
import com.maxifier.mxcache.impl.resource.ResourceOccupied;
import com.maxifier.mxcache.provider.CacheDescriptor;
import com.maxifier.mxcache.storage.ObjectIntStorage;

public abstract class AbstractObjectIntCache<E>
extends AbstractCache
implements ObjectIntCache<E>,
ObjectIntStorage<E> {
    private final ObjectIntCalculatable<E> calculatable;

    public AbstractObjectIntCache(Object owner, ObjectIntCalculatable<E> calculatable, MutableStatistics statistics) {
        super(owner, statistics);
        this.calculatable = calculatable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public int getOrCreate(E o) {
        if (DependencyTracker.isBypassCaches()) {
            return this.calculatable.calculate(this.owner, o);
        }
        this.lock();
        try {
            if (this.isCalculated(o)) {
                DependencyTracker.mark(this.getDependencyNode());
                this.hit();
                int n = this.load(o);
                return n;
            }
            DependencyNode callerNode = DependencyTracker.track(this.getDependencyNode());
            while (true) {
                int n;
                try {
                    n = this.create(o);
                }
                catch (ResourceOccupied e) {
                    block19: {
                        if (callerNode != null) {
                            throw e;
                        }
                        this.unlock();
                        try {
                            e.getResource().waitForEndOfModification();
                        }
                        finally {
                            this.lock();
                        }
                        if (!this.isCalculated(o)) break block19;
                        this.hit();
                        int n2 = this.load(o);
                        DependencyTracker.exit(callerNode);
                        this.unlock();
                        return n2;
                    }
                    continue;
                    {
                        catch (Throwable throwable) {
                            DependencyTracker.exit(callerNode);
                            throw throwable;
                        }
                    }
                }
                DependencyTracker.exit(callerNode);
                return n;
                break;
            }
        }
        finally {
            this.unlock();
        }
    }

    protected int create(E o) {
        long start = System.nanoTime();
        int t = this.calculatable.calculate(this.owner, o);
        long end = System.nanoTime();
        this.miss(end - start);
        this.save(o, t);
        return t;
    }

    @Override
    public CacheDescriptor getDescriptor() {
        CacheId id = CalculatableHelper.getId(this.calculatable.getClass());
        return CacheFactory.getProvider().getDescriptor(id);
    }

    @Override
    public String toString() {
        return this.getDescriptor() + ": " + this.owner;
    }
}

