/*
 * Decompiled with CFR 0.152.
 */
package com.maxifier.mxcache.impl.caches.abs.elementlocked;

import com.maxifier.mxcache.CacheFactory;
import com.maxifier.mxcache.caches.CharacterFloatCache;
import com.maxifier.mxcache.caches.CharacterFloatCalculatable;
import com.maxifier.mxcache.impl.CacheId;
import com.maxifier.mxcache.impl.CalculatableHelper;
import com.maxifier.mxcache.impl.MutableStatistics;
import com.maxifier.mxcache.impl.caches.abs.elementlocked.AbstractElementLockedCache;
import com.maxifier.mxcache.impl.resource.DependencyNode;
import com.maxifier.mxcache.impl.resource.DependencyTracker;
import com.maxifier.mxcache.impl.resource.ResourceOccupied;
import com.maxifier.mxcache.provider.CacheDescriptor;
import com.maxifier.mxcache.storage.elementlocked.CharacterFloatElementLockedStorage;

public abstract class AbstractCharacterFloatCache
extends AbstractElementLockedCache
implements CharacterFloatCache,
CharacterFloatElementLockedStorage {
    private final CharacterFloatCalculatable calculatable;

    public AbstractCharacterFloatCache(Object owner, CharacterFloatCalculatable calculatable, MutableStatistics statistics) {
        super(owner, statistics);
        this.calculatable = calculatable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public float getOrCreate(char o) {
        if (DependencyTracker.isBypassCaches()) {
            return this.calculatable.calculate(this.owner, o);
        }
        this.lock(o);
        try {
            if (this.isCalculated(o)) {
                DependencyTracker.mark(this.getDependencyNode());
                this.hit();
                float f = this.load(o);
                return f;
            }
            DependencyNode callerNode = DependencyTracker.track(this.getDependencyNode());
            while (true) {
                float f;
                try {
                    f = this.create(o);
                }
                catch (ResourceOccupied e) {
                    block19: {
                        if (callerNode != null) {
                            throw e;
                        }
                        this.unlock(o);
                        try {
                            e.getResource().waitForEndOfModification();
                        }
                        finally {
                            this.lock(o);
                        }
                        if (!this.isCalculated(o)) break block19;
                        this.hit();
                        float f2 = this.load(o);
                        DependencyTracker.exit(callerNode);
                        this.unlock(o);
                        return f2;
                    }
                    continue;
                    {
                        catch (Throwable throwable) {
                            DependencyTracker.exit(callerNode);
                            throw throwable;
                        }
                    }
                }
                DependencyTracker.exit(callerNode);
                return f;
                break;
            }
        }
        finally {
            this.unlock(o);
        }
    }

    protected float create(char key) {
        long start = System.nanoTime();
        float t = this.calculatable.calculate(this.owner, key);
        long end = System.nanoTime();
        this.miss(end - start);
        this.save(key, t);
        return t;
    }

    @Override
    public CacheDescriptor getDescriptor() {
        CacheId id = CalculatableHelper.getId(this.calculatable.getClass());
        return CacheFactory.getProvider().getDescriptor(id);
    }

    public String toString() {
        return this.getDescriptor() + ": " + this.owner;
    }
}

