/*
 * Decompiled with CFR 0.152.
 */
package com.maxifier.mxcache.impl.caches.batch;

import com.maxifier.mxcache.impl.caches.batch.KeyStrategy;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

final class CollectionKeyStrategy<T>
implements KeyStrategy<Collection<T>, T, Iterator<T>> {
    private static final CollectionKeyStrategy INSTANCE = new CollectionKeyStrategy();

    private CollectionKeyStrategy() {
    }

    public static <T> CollectionKeyStrategy<T> getInstance() {
        return INSTANCE;
    }

    @Override
    public int size(Collection<T> key) {
        return key.size();
    }

    @Override
    public Iterator<T> iterator(Collection<T> key) {
        return key.iterator();
    }

    @Override
    public T get(int order, Iterator<T> iterator) {
        return iterator.next();
    }

    @Override
    public Collection<T> toKey(Collection<T> key, int n) {
        return key;
    }

    @Override
    public Collection<T> create(Collection<T> expectedType) {
        if (expectedType instanceof SortedSet) {
            return new TreeSet();
        }
        if (expectedType instanceof Set) {
            return new THashSet(expectedType.size());
        }
        return new ArrayList(expectedType.size());
    }

    @Override
    public boolean isStableOrder() {
        return false;
    }

    @Override
    public boolean put(Collection<T> key, int index, T value) {
        return key.add(value);
    }
}

