/*
 * Decompiled with CFR 0.152.
 */
package com.maxifier.mxcache.impl.caches.def;

import com.maxifier.mxcache.impl.caches.def.ObjectBooleanTroveStorage;
import com.maxifier.mxcache.transform.SmartReference;
import com.maxifier.mxcache.tuple.Tuple;
import gnu.trove.strategy.HashingStrategy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class TupleBooleanWeakTroveStorage
extends ObjectBooleanTroveStorage<Tuple> {
    private final List<Tuple> removed = Collections.synchronizedList(new ArrayList());
    private final int[] tupleIndices;

    public TupleBooleanWeakTroveStorage() {
        throw new UnsupportedOperationException("TupleBooleanWeakTroveStorage actually is not externalizable");
    }

    public TupleBooleanWeakTroveStorage(int[] tupleIndices) {
        this.tupleIndices = tupleIndices;
    }

    public TupleBooleanWeakTroveStorage(HashingStrategy<Tuple> strategy, int[] tupleIndices) {
        super(strategy);
        this.tupleIndices = tupleIndices;
    }

    private void cleanup() {
        for (Tuple t : this.removed) {
            this.remove(t);
        }
        this.removed.clear();
    }

    @Override
    public boolean load(Tuple o) {
        this.cleanup();
        return super.load(o);
    }

    @Override
    public void save(Tuple o, boolean t) {
        this.cleanup();
        Callback callback = new Callback(o);
        for (int index : this.tupleIndices) {
            ((SmartReference)o.get(index)).setCallback(callback);
        }
        super.save(o, t);
    }

    private class Callback
    implements Runnable {
        private final Tuple o;

        public Callback(Tuple o) {
            this.o = o;
        }

        @Override
        public void run() {
            TupleBooleanWeakTroveStorage.this.removed.add(this.o);
        }
    }
}

