/*
 * Decompiled with CFR 0.152.
 */
package com.maxifier.mxcache.impl.caches.def;

import com.maxifier.mxcache.impl.caches.def.ObjectFloatTroveStorage;
import com.maxifier.mxcache.transform.SmartReference;
import com.maxifier.mxcache.tuple.Tuple;
import gnu.trove.strategy.HashingStrategy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class TupleFloatWeakTroveStorage
extends ObjectFloatTroveStorage<Tuple> {
    private final List<Tuple> removed = Collections.synchronizedList(new ArrayList());
    private final int[] tupleIndices;

    public TupleFloatWeakTroveStorage() {
        throw new UnsupportedOperationException("TupleFloatWeakTroveStorage actually is not externalizable");
    }

    public TupleFloatWeakTroveStorage(int[] tupleIndices) {
        this.tupleIndices = tupleIndices;
    }

    public TupleFloatWeakTroveStorage(HashingStrategy<Tuple> strategy, int[] tupleIndices) {
        super(strategy);
        this.tupleIndices = tupleIndices;
    }

    private void cleanup() {
        for (Tuple t : this.removed) {
            this.remove(t);
        }
        this.removed.clear();
    }

    @Override
    public float load(Tuple o) {
        this.cleanup();
        return super.load(o);
    }

    @Override
    public void save(Tuple o, float t) {
        this.cleanup();
        Callback callback = new Callback(o);
        for (int index : this.tupleIndices) {
            ((SmartReference)o.get(index)).setCallback(callback);
        }
        super.save(o, t);
    }

    private class Callback
    implements Runnable {
        private final Tuple o;

        public Callback(Tuple o) {
            this.o = o;
        }

        @Override
        public void run() {
            TupleFloatWeakTroveStorage.this.removed.add(this.o);
        }
    }
}

