/*
 * Decompiled with CFR 0.152.
 */
package com.maxifier.mxcache.impl.caches.def;

import com.maxifier.mxcache.impl.caches.def.ObjectLongTroveStorage;
import com.maxifier.mxcache.transform.SmartReference;
import com.maxifier.mxcache.tuple.Tuple;
import gnu.trove.strategy.HashingStrategy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class TupleLongWeakTroveStorage
extends ObjectLongTroveStorage<Tuple> {
    private final List<Tuple> removed = Collections.synchronizedList(new ArrayList());
    private final int[] tupleIndices;

    public TupleLongWeakTroveStorage() {
        throw new UnsupportedOperationException("TupleLongWeakTroveStorage actually is not externalizable");
    }

    public TupleLongWeakTroveStorage(int[] tupleIndices) {
        this.tupleIndices = tupleIndices;
    }

    public TupleLongWeakTroveStorage(HashingStrategy<Tuple> strategy, int[] tupleIndices) {
        super(strategy);
        this.tupleIndices = tupleIndices;
    }

    private void cleanup() {
        for (Tuple t : this.removed) {
            this.remove(t);
        }
        this.removed.clear();
    }

    @Override
    public long load(Tuple o) {
        this.cleanup();
        return super.load(o);
    }

    @Override
    public void save(Tuple o, long t) {
        this.cleanup();
        Callback callback = new Callback(o);
        for (int index : this.tupleIndices) {
            ((SmartReference)o.get(index)).setCallback(callback);
        }
        super.save(o, t);
    }

    private class Callback
    implements Runnable {
        private final Tuple o;

        public Callback(Tuple o) {
            this.o = o;
        }

        @Override
        public void run() {
            TupleLongWeakTroveStorage.this.removed.add(this.o);
        }
    }
}

