/*
 * Decompiled with CFR 0.152.
 */
package com.maxifier.mxcache.impl.instanceprovider;

import com.maxifier.mxcache.InstanceProvider;
import com.maxifier.mxcache.NoSuchInstanceException;
import com.maxifier.mxcache.impl.instanceprovider.Binder;
import com.maxifier.mxcache.impl.instanceprovider.BinderImpl;
import com.maxifier.mxcache.impl.instanceprovider.Provider;
import gnu.trove.map.hash.THashMap;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nonnull;

public final class DefaultInstanceProvider
implements InstanceProvider {
    private static final DefaultInstanceProvider INSTANCE = new DefaultInstanceProvider();
    private final Map<Class, Provider> registry = Collections.synchronizedMap(new THashMap());

    private DefaultInstanceProvider() {
    }

    public static DefaultInstanceProvider getInstance() {
        return INSTANCE;
    }

    public <T> Binder<T> bind(Class<T> t) {
        return new BinderImpl<T>(this, this.registry, t);
    }

    public void clearBinding(Class cls) {
        this.registry.remove(cls);
    }

    @Override
    @Nonnull
    public <T> T forClass(@Nonnull Class<T> cls) {
        Provider provider = this.registry.get(cls);
        if (provider == null) {
            return DefaultInstanceProvider.createInstance(cls);
        }
        return provider.get();
    }

    private static <T> T createInstance(@Nonnull Class<T> cls) {
        try {
            return cls.newInstance();
        }
        catch (InstantiationException e) {
            throw new NoSuchInstanceException(e);
        }
        catch (IllegalAccessException e) {
            throw new NoSuchInstanceException(e);
        }
    }
}

