/*
 * Decompiled with CFR 0.152.
 */
package com.maxifier.mxcache.impl.resource;

import com.maxifier.mxcache.impl.resource.DependencyNode;
import com.maxifier.mxcache.impl.resource.DependencyNodeVisitor;
import com.maxifier.mxcache.impl.resource.nodes.ResourceViewable;
import gnu.trove.map.hash.TCustomHashMap;
import gnu.trove.strategy.HashingStrategy;
import gnu.trove.strategy.IdentityHashingStrategy;
import java.util.Map;
import java.util.Queue;
import java.util.Set;

public class CollectingChangedDependencyNodeVisitor
implements DependencyNodeVisitor {
    private final Set<DependencyNode> nodes;
    private final Queue<DependencyNode> queue;
    private final Map<ResourceViewable, Boolean> changedCache = new TCustomHashMap((HashingStrategy)IdentityHashingStrategy.INSTANCE);

    public CollectingChangedDependencyNodeVisitor(Set<DependencyNode> nodes, Queue<DependencyNode> queue) {
        this.nodes = nodes;
        this.queue = queue;
    }

    @Override
    public void visit(DependencyNode node) {
        if (node instanceof ResourceViewable) {
            ResourceViewable resourceViewable = (ResourceViewable)((Object)node);
            if (this.nodes.contains(node) || !this.isChanged(resourceViewable)) {
                return;
            }
        }
        if (this.nodes.add(node)) {
            this.queue.add(node);
        }
    }

    private boolean isChanged(ResourceViewable resourceViewable) {
        Boolean res = this.changedCache.get(resourceViewable);
        if (res == null) {
            res = resourceViewable.isChanged();
            this.changedCache.put(resourceViewable, res);
        }
        return res;
    }

    @Override
    public Set<DependencyNode> getNodes() {
        return this.nodes;
    }

    @Override
    public Queue<DependencyNode> getQueue() {
        return this.queue;
    }
}

