/*
 * Decompiled with CFR 0.152.
 */
package com.maxifier.mxcache.impl.resource;

import com.maxifier.mxcache.impl.resource.DependencyNode;
import com.maxifier.mxcache.impl.resource.DependencyNodeVisitor;
import com.maxifier.mxcache.impl.resource.nodes.ResourceViewable;
import gnu.trove.set.hash.THashSet;
import java.util.Queue;
import java.util.Set;

public class ResourceViewDependencyNodeVisitor
implements DependencyNodeVisitor {
    private final Set<DependencyNode> resourceViewableNodes;
    private final Set<DependencyNode> allNodes;
    private final Queue<DependencyNode> queue;

    public ResourceViewDependencyNodeVisitor(Set<DependencyNode> resourceViewableNodes, Queue<DependencyNode> queue) {
        this.resourceViewableNodes = resourceViewableNodes;
        this.allNodes = new THashSet();
        this.queue = queue;
    }

    @Override
    public void visit(DependencyNode node) {
        if (node instanceof ResourceViewable) {
            this.resourceViewableNodes.add(node);
        }
        if (this.allNodes.add(node)) {
            this.queue.add(node);
        }
    }

    @Override
    public Set<DependencyNode> getNodes() {
        return this.resourceViewableNodes;
    }

    @Override
    public Queue<DependencyNode> getQueue() {
        return this.queue;
    }
}

