/*
 * Decompiled with CFR 0.152.
 */
package com.maxifier.mxcache.impl.resource.nodes;

import com.maxifier.mxcache.caches.CleaningNode;
import com.maxifier.mxcache.impl.resource.AbstractDependencyNode;
import com.maxifier.mxcache.util.TIdentityHashSet;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;

public class MultipleDependencyNode
extends AbstractDependencyNode {
    protected final List<WeakReference<CleaningNode>> instances = new ArrayList<WeakReference<CleaningNode>>();

    @Override
    public synchronized void addNode(@Nonnull CleaningNode node) {
        this.instances.add(new WeakReference<CleaningNode>(node));
    }

    @Override
    public synchronized void appendNodes(TIdentityHashSet<CleaningNode> elements) {
        Iterator<WeakReference<CleaningNode>> it = this.instances.iterator();
        while (it.hasNext()) {
            WeakReference<CleaningNode> ref = it.next();
            CleaningNode node = (CleaningNode)ref.get();
            if (node != null) {
                elements.add(node);
                continue;
            }
            it.remove();
        }
    }

    public String toString() {
        StringBuilder b = new StringBuilder("DependencyNode<");
        int gc = 0;
        int n = 0;
        for (WeakReference<CleaningNode> instance : this.instances) {
            CleaningNode node = (CleaningNode)instance.get();
            if (node == null) {
                ++gc;
                continue;
            }
            ++n;
            b.append(node.toString()).append(", ");
        }
        if (gc > 0) {
            b.append(gc).append(" GCed");
        } else if (n > 0) {
            b.setLength(b.length() - 2);
        }
        b.append(">");
        return b.toString();
    }
}

