/*
 * Decompiled with CFR 0.152.
 */
package com.maxifier.mxcache.provider;

import com.maxifier.mxcache.CacheFactory;
import com.maxifier.mxcache.DependencyTracking;
import com.maxifier.mxcache.NoSuchInstanceException;
import com.maxifier.mxcache.ResourceView;
import com.maxifier.mxcache.StatisticsMode;
import com.maxifier.mxcache.StatisticsModeEnum;
import com.maxifier.mxcache.caches.Cache;
import com.maxifier.mxcache.caches.Calculable;
import com.maxifier.mxcache.config.Rule;
import com.maxifier.mxcache.context.CacheContext;
import com.maxifier.mxcache.provider.AnnotationProperty;
import com.maxifier.mxcache.provider.CachingStrategy;
import com.maxifier.mxcache.provider.PropertyConvertationException;
import com.maxifier.mxcache.provider.PropertyOverrides;
import com.maxifier.mxcache.provider.Signature;
import com.maxifier.mxcache.provider.StrategyProperty;
import com.maxifier.mxcache.proxy.ProxyFactory;
import com.maxifier.mxcache.proxy.UseProxy;
import com.maxifier.mxcache.transform.TransformGenerator;
import com.maxifier.mxcache.transform.TransformGeneratorFactoryImpl;
import com.maxifier.mxcache.util.CodegenHelper;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheDescriptor<T> {
    private static final Logger logger = LoggerFactory.getLogger(CacheDescriptor.class);
    private static final StrategyProperty<Class> USE_PROXY = StrategyProperty.create("use.proxy", Class.class, UseProxy.class, "value");
    private static final StrategyProperty<StatisticsModeEnum> STATISTICS_MODE = StrategyProperty.create("statistics.mode", StatisticsModeEnum.class, StatisticsMode.class, "value");
    private final Class<T> ownerClass;
    private final Signature signature;
    private final Signature transformedSignature;
    private final Calculable calculable;
    private final int id;
    private final Method method;
    private final String group;
    private final String[] tags;
    private final Rule rule;
    private final ProxyFactory proxyFactory;
    private final TransformGenerator keyTransform;
    private final TransformGenerator valueTransform;
    private final PropertyOverrides overrides;

    public CacheDescriptor(Class<T> ownerClass, int id, Class keyType, Class valueType, Calculable calculable, String methodName, String methodDesc, String cacheName, String group, String[] tags, ProxyFactory proxyFactory) {
        this(ownerClass, id, keyType, valueType, calculable, methodName, methodDesc, cacheName, group, tags, CacheFactory.getConfiguration().getRule(ownerClass, group, tags), proxyFactory);
    }

    public CacheDescriptor(Class<T> ownerClass, int id, Class keyType, Class valueType, Calculable calculable, String methodName, String methodDesc, String cacheName, String group, String[] tags, @Nonnull Rule rule, ProxyFactory proxyFactory) {
        this(ownerClass, id, keyType, valueType, calculable, CodegenHelper.getMethod(ownerClass, methodName, methodDesc), cacheName, group, tags, rule, proxyFactory);
    }

    private CacheDescriptor(Class<T> ownerClass, int id, Class keyType, Class valueType, Calculable calculable, Method method, String cacheName, String group, String[] tags, @Nonnull Rule rule, ProxyFactory proxyFactory) {
        this(ownerClass, id, CacheDescriptor.signature(keyType, valueType, method), calculable, method, cacheName, group, tags, rule, proxyFactory, null);
    }

    private static Signature signature(Class keyType, Class valueType, Method method) {
        if (keyType == null) {
            return Signature.of(null, valueType);
        }
        return new Signature(method.getParameterTypes(), keyType, valueType);
    }

    private CacheDescriptor(Class<T> ownerClass, int id, Signature signature, Calculable calculable, Method method, String cacheName, String group, String[] tags, @Nonnull Rule rule, ProxyFactory proxyFactory, @Nullable PropertyOverrides overrides) {
        this(ownerClass, id, signature, calculable, method, cacheName, group, tags, rule, proxyFactory, TransformGeneratorFactoryImpl.getInstance().forMethod(method), TransformGenerator.NO_TRANSFORM, overrides);
    }

    private CacheDescriptor(Class<T> ownerClass, int id, Signature signature, Calculable calculable, Method method, String cacheName, String group, String[] tags, @Nonnull Rule rule, ProxyFactory proxyFactory, TransformGenerator keyTransform, TransformGenerator valueTransform, PropertyOverrides overrides) {
        this(ownerClass, id, signature, calculable, method, cacheName, group, tags, rule, proxyFactory, keyTransform, valueTransform, CacheDescriptor.getTransformedSignature(signature, keyTransform, valueTransform), overrides);
    }

    private static Signature getTransformedSignature(Signature signature, TransformGenerator keyTransform, TransformGenerator valueTransform) {
        return valueTransform.transformValue(keyTransform.transformKey(signature));
    }

    private CacheDescriptor(Class<T> ownerClass, int id, Signature signature, Calculable calculable, Method method, String cacheName, String group, String[] tags, @Nonnull Rule rule, ProxyFactory proxyFactory, TransformGenerator keyTransform, TransformGenerator valueTransform, Signature transformedSignature, PropertyOverrides overrides) {
        this.method = method;
        this.group = group;
        this.ownerClass = ownerClass;
        this.calculable = calculable;
        this.id = id;
        this.tags = tags;
        this.rule = rule;
        this.signature = signature;
        this.proxyFactory = proxyFactory;
        this.keyTransform = keyTransform;
        this.valueTransform = valueTransform;
        this.transformedSignature = transformedSignature;
        this.overrides = overrides;
        rule.override(method, cacheName);
    }

    public CacheDescriptor<T> overrideCalculable(Calculable calculatable) {
        Class<?> calculatableInterface = this.getCalculatableInterface();
        if (!calculatableInterface.isInstance(calculatable)) {
            throw new IllegalArgumentException("Calculatable for " + this + " should implement " + calculatableInterface.getName());
        }
        return new CacheDescriptor<T>(this.ownerClass, this.id, this.signature, calculatable, this.method, null, this.group, this.tags, this.rule, this.proxyFactory, this.keyTransform, this.valueTransform, this.transformedSignature, this.overrides);
    }

    public CacheDescriptor<T> overrideProxyFactory(ProxyFactory factory) {
        return new CacheDescriptor<T>(this.ownerClass, this.id, this.signature, this.calculable, this.method, null, this.group, this.tags, this.rule, factory, this.keyTransform, this.valueTransform, this.transformedSignature, this.overrides);
    }

    public CacheDescriptor<T> overrideProxyFactory(Class<? extends ProxyFactory> factory) {
        return new CacheDescriptor<T>(this.ownerClass, this.id, this.signature, this.calculable, this.method, null, this.group, this.tags, this.rule, this.proxyFactory, this.keyTransform, this.valueTransform, this.transformedSignature, new PropertyOverrides(this.overrides).override(USE_PROXY, factory));
    }

    public Class getKeyType() {
        return this.signature.getContainer();
    }

    public Class getValueType() {
        return this.signature.getValue();
    }

    public Calculable getCalculable() {
        return this.calculable;
    }

    public int getId() {
        return this.id;
    }

    public Method getMethod() {
        return this.method;
    }

    public String[] getTags() {
        return (String[])this.tags.clone();
    }

    public String getGroup() {
        return this.group;
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.method.getModifiers());
    }

    public boolean isResourceView() {
        return this.method.getAnnotation(ResourceView.class) != null;
    }

    public Class<T> getOwnerClass() {
        return this.ownerClass;
    }

    public String toString() {
        return "mxcache:" + this.method;
    }

    public <T> T getProperty(StrategyProperty<T> property) throws PropertyConvertationException {
        T value;
        if (this.overrides != null && (value = this.overrides.get(property)) != null) {
            return value;
        }
        if (property instanceof AnnotationProperty) {
            return this.getPropertyWithoutOverride((AnnotationProperty)property);
        }
        return this.getPropertyFromRule(property);
    }

    public <T, A extends Annotation> T getProperty(AnnotationProperty<A, T> property) throws PropertyConvertationException {
        Object value;
        if (this.overrides != null && (value = this.overrides.get(property)) != null) {
            return value;
        }
        return this.getPropertyWithoutOverride(property);
    }

    private <T, A extends Annotation> T getPropertyWithoutOverride(AnnotationProperty<A, T> property) {
        if (this.rule.isImportantProperty(property.getName())) {
            return this.getPropertyFromRule(property);
        }
        A annotation = this.method.getAnnotation(property.getAnnotationType());
        if (annotation == null) {
            return this.getPropertyFromRule(property);
        }
        T value = property.getFromAnnotation(annotation);
        if (value == null) {
            return this.getPropertyFromRule(property);
        }
        return value;
    }

    private <T> T getPropertyFromRule(StrategyProperty<T> property) throws PropertyConvertationException {
        Object value = this.rule.getProperty(property.getName());
        if (value == null) {
            return property.getDefaultValue();
        }
        return (T)CacheDescriptor.deconvert(property.getType(), value);
    }

    private static Object deconvert(Class<?> type, Object value) throws PropertyConvertationException {
        try {
            if (type == String.class) {
                return value;
            }
            if (type == Class.class) {
                return Class.forName((String)value);
            }
            if (type == Boolean.class) {
                return Boolean.valueOf((String)value);
            }
            if (type == Integer.class) {
                return Integer.valueOf((String)value);
            }
            if (type == Long.class) {
                return Long.valueOf((String)value);
            }
            if (type == Float.class) {
                return Float.valueOf((String)value);
            }
            if (type == Double.class) {
                return Double.valueOf((String)value);
            }
            if (type.isEnum()) {
                return Enum.valueOf(type, (String)value);
            }
            if (type.isArray()) {
                Class<?> componentType = type.getComponentType();
                if (value instanceof List) {
                    return CacheDescriptor.deconvertArray(value, componentType);
                }
                return CacheDescriptor.deconvertScalarArray(value, componentType);
            }
        }
        catch (Exception e) {
            throw new PropertyConvertationException("Cannot convert " + value + " to " + type, e);
        }
        throw new IllegalArgumentException("Unsupported property type");
    }

    private static Object deconvertScalarArray(Object value, Class<?> componentType) throws PropertyConvertationException {
        Object array = Array.newInstance(componentType, 1);
        Array.set(array, 0, CacheDescriptor.deconvert(componentType, value));
        return array;
    }

    private static Object deconvertArray(Object value, Class<?> componentType) throws PropertyConvertationException {
        List list = (List)value;
        Object array = Array.newInstance(componentType, list.size());
        int index = 0;
        for (Object o : list) {
            Array.set(array, index++, CacheDescriptor.deconvert(componentType, o));
        }
        return array;
    }

    public Set<String> getResourceDependencies() {
        return this.rule.getResourceDependencies();
    }

    public DependencyTracking getTrackDependency() {
        return this.rule.getTrackDependency();
    }

    public Class<? extends CachingStrategy> getStrategyClass() {
        return this.rule.getStrategy();
    }

    public Class<? extends Cache> getCacheInterface() {
        return this.signature.getCacheInterface();
    }

    public Class<?> getCalculatableInterface() {
        return this.signature.getCalculableInterface();
    }

    public Signature getSignature() {
        return this.signature;
    }

    public StatisticsModeEnum getStatisticsMode() {
        return this.getProperty(STATISTICS_MODE);
    }

    private ProxyFactory getDefaultProxyFactory(CacheContext context) {
        Class proxyFactoryClass = this.getProperty(USE_PROXY);
        if (proxyFactoryClass == null) {
            return null;
        }
        if (!ProxyFactory.class.isAssignableFrom(proxyFactoryClass)) {
            logger.error("Proxy factory class should implement ProxyFactory: {}", (Object)proxyFactoryClass);
            return null;
        }
        return CacheDescriptor.getProxyFactory(context, proxyFactoryClass);
    }

    private static ProxyFactory getProxyFactory(CacheContext context, Class<? extends ProxyFactory> proxyFactoryClass) {
        try {
            return context.getInstanceProvider().forClass(proxyFactoryClass);
        }
        catch (NoSuchInstanceException e) {
            logger.error("Invalid proxy factory class: " + proxyFactoryClass, (Throwable)e);
            return null;
        }
    }

    public ProxyFactory getProxyFactory(CacheContext context) {
        return this.proxyFactory == null ? this.getDefaultProxyFactory(context) : this.proxyFactory;
    }

    public TransformGenerator getKeyTransform() {
        return this.keyTransform;
    }

    public TransformGenerator getValueTransform() {
        return this.valueTransform;
    }

    public Signature getTransformedSignature() {
        return this.transformedSignature;
    }

    public boolean isDisabled() {
        return this.rule.getDisableCache();
    }

    public String getCacheName() {
        return this.rule.getCacheName();
    }
}

