/*
 * Decompiled with CFR 0.152.
 */
package com.maxifier.mxcache.provider;

import com.maxifier.mxcache.asm.Type;
import com.maxifier.mxcache.caches.Cache;
import com.maxifier.mxcache.impl.caches.abs.elementlocked.ElementLockedStorage;
import com.maxifier.mxcache.impl.resource.nodes.MultipleDependencyNode;
import com.maxifier.mxcache.impl.resource.nodes.SingletonDependencyNode;
import com.maxifier.mxcache.storage.Storage;
import gnu.trove.map.hash.THashMap;
import java.util.Arrays;
import java.util.Map;
import java.util.WeakHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Signature {
    private static final String CACHES_PACKAGE_NAME = "com.maxifier.mxcache.caches.";
    private static final String STORAGE_PACKAGE_NAME = "com.maxifier.mxcache.storage.";
    private static final String LOCKED_STORAGE_PACKAGE_NAME = "com.maxifier.mxcache.storage.elementlocked.";
    private static final String SINGLETON_NODES_PACKAGE_NAME = "com.maxifier.mxcache.impl.resource.nodes.ViewableSingleton";
    private static final String MULTIPLE_NODES_PACKAGE_NAME = "com.maxifier.mxcache.impl.resource.nodes.ViewableMultiple";
    private static final int PRIMITIVE_TYPE_COUNT = 8;
    private static final Class[] BASIC_TYPES = new Class[]{Boolean.TYPE, Byte.TYPE, Short.TYPE, Character.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, Object.class, null};
    private static final Map<Class, Map<Class, Signature>> BASIC;
    private static final Map<Class, Signature> CACHE;
    private static final Map<Class, String> PRIMITIVE_NAMES;
    private static final Signature UNKNOWN;
    private final Class[] keys;
    @Nullable
    private final Class container;
    private final Class value;
    private final Signature erased;

    private static Map<Class, String> createPrimitiveNamesCache() {
        THashMap primitiveNames = new THashMap(8);
        primitiveNames.put(Boolean.TYPE, "Boolean");
        primitiveNames.put(Byte.TYPE, "Byte");
        primitiveNames.put(Short.TYPE, "Short");
        primitiveNames.put(Character.TYPE, "Character");
        primitiveNames.put(Integer.TYPE, "Int");
        primitiveNames.put(Long.TYPE, "Long");
        primitiveNames.put(Float.TYPE, "Float");
        primitiveNames.put(Double.TYPE, "Double");
        return primitiveNames;
    }

    public Signature erased() {
        return this.erased;
    }

    @Nonnull
    public static synchronized Signature of(@Nullable Class container, @Nonnull Class value) {
        Map<Class, Signature> byValue = BASIC.get(container);
        if (byValue == null) {
            return new Signature(container, value);
        }
        Signature signature = byValue.get(value);
        if (signature == null) {
            return new Signature(container, value);
        }
        return signature;
    }

    @Nonnull
    public static synchronized Signature ofStorage(@Nonnull Class<? extends Storage> c) {
        Signature s = CACHE.get(c);
        if (s == null) {
            s = Signature.extractSignature(c);
            CACHE.put(c, s);
        }
        if (s == UNKNOWN) {
            throw new IllegalArgumentException("No signature found for " + c);
        }
        return s;
    }

    @Nonnull
    private static synchronized Signature extractSignature(Class c) {
        Signature res = null;
        Class p = c;
        do {
            for (Class<?> intf : p.getInterfaces()) {
                Signature s;
                if (!intf.getName().startsWith(STORAGE_PACKAGE_NAME) || !intf.getName().endsWith("Storage") || (s = CACHE.get(intf)) == null) continue;
                if (res != null && s.equals(res)) {
                    throw new IllegalArgumentException("Class " + c + " has too many signatures");
                }
                res = s;
            }
        } while ((p = p.getSuperclass()) != null);
        return res == null ? UNKNOWN : res;
    }

    public Signature(Class[] keys, Class tuple, Class value) {
        this.keys = keys;
        this.container = tuple;
        this.value = value;
        this.erased = this instanceof BasicSignature ? this : Signature.of(Signature.erase(tuple), Signature.erase(value));
    }

    public Signature(Class key, Class value) {
        if (key == null) {
            this.keys = null;
            this.container = null;
        } else {
            this.keys = new Class[]{key};
            this.container = key;
        }
        this.value = value;
        if (value == null && key == null) {
            if (UNKNOWN != null) {
                throw new IllegalArgumentException("value & key should not be null");
            }
            this.erased = null;
        } else {
            this.erased = this instanceof BasicSignature ? this : Signature.of(Signature.erase(key), Signature.erase(value));
        }
    }

    private static Class erase(Class k) {
        if (k != null && !k.isPrimitive()) {
            return Object.class;
        }
        return k;
    }

    public boolean hasKeys() {
        return this.container != null;
    }

    @Nullable
    public Class getContainer() {
        return this.container;
    }

    public Type getContainerType() {
        return this.container == null ? null : Type.getType((Class)this.container);
    }

    public Class getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Signature)) {
            return false;
        }
        Signature signature = (Signature)o;
        return this.container == signature.container && this.value == signature.value;
    }

    public int hashCode() {
        if (this.container == null) {
            return this.value.hashCode();
        }
        return 31 * this.container.hashCode() + this.value.hashCode();
    }

    public String toString() {
        if (this.container == null) {
            return this.value.getName() + "()";
        }
        StringBuilder b = new StringBuilder();
        b.append(this.value.getName()).append("(");
        if (this.keys == null) {
            b.append(this.container.getName());
        } else {
            b.append("Tuple:").append(Arrays.toString(this.keys));
        }
        b.append(")");
        return b.toString();
    }

    public Class<?> getImplementationClass(String prefix, String postfix) {
        return this.erased.getImplementationClass(prefix, postfix);
    }

    public String getImplementationClassName(String prefix, String postfix) {
        return this.erased.getImplementationClassName(prefix, postfix);
    }

    public static String toString(Class c) {
        if (c == null) {
            return "";
        }
        if (!c.isPrimitive()) {
            return "Object";
        }
        return PRIMITIVE_NAMES.get(c);
    }

    public Class getKey(int index) {
        return this.keys[index];
    }

    public int getKeyCount() {
        return this.keys.length;
    }

    public Class<? extends Cache> getCacheInterface() {
        return this.erased.getCacheInterface();
    }

    public Class<?> getCalculableInterface() {
        return this.erased.getCalculableInterface();
    }

    public Class<? extends Storage> getStorageInterface() {
        return this.erased.getStorageInterface();
    }

    public Class<? extends ElementLockedStorage> getElementLockedStorageInterface() {
        return this.erased.getElementLockedStorageInterface();
    }

    public Class<? extends SingletonDependencyNode> getSingletonDependencyNodeInterface() {
        return this.erased.getSingletonDependencyNodeInterface();
    }

    public Class<? extends MultipleDependencyNode> getMultipleDependencyNodeInterface() {
        return this.erased.getMultipleDependencyNodeInterface();
    }

    public boolean isWider(Signature other) {
        return (this.container == other.container || this.container != null && other.container != null && this.container.isAssignableFrom(other.container)) && (this.value == other.value || this.value.isAssignableFrom(other.value));
    }

    public Signature overrideKey(Class key) {
        if (key == this.container && this.keys.length == 1 && this.keys[0] == key) {
            return this;
        }
        return Signature.of(key, this.value);
    }

    public Signature overrideKeys(Class[] keys, Class container) {
        if (Arrays.equals(keys, this.keys) && container == this.container) {
            return this;
        }
        return new Signature(keys, container, this.value);
    }

    public Signature overrideValue(Class value) {
        if (value == this.value) {
            return this;
        }
        return new Signature(this.keys, this.container, value);
    }

    static {
        PRIMITIVE_NAMES = Signature.createPrimitiveNamesCache();
        CACHE = new WeakHashMap<Class, Signature>(BASIC_TYPES.length * (BASIC_TYPES.length - 1));
        BASIC = new THashMap(BASIC_TYPES.length);
        for (Class e : BASIC_TYPES) {
            THashMap byValue = new THashMap(BASIC_TYPES.length - 1);
            BASIC.put(e, (Map<Class, Signature>)byValue);
            for (Class f : BASIC_TYPES) {
                if (f == null) continue;
                BasicSignature s = new BasicSignature(e, f);
                CACHE.put(((Signature)s).getCacheInterface(), s);
                CACHE.put(((Signature)s).getCalculableInterface(), s);
                CACHE.put(((Signature)s).getStorageInterface(), s);
                CACHE.put(((Signature)s).getElementLockedStorageInterface(), s);
                if (e == null) {
                    CACHE.put(((Signature)s).getSingletonDependencyNodeInterface(), s);
                    CACHE.put(((Signature)s).getMultipleDependencyNodeInterface(), s);
                }
                byValue.put(f, s);
            }
        }
        UNKNOWN = new Signature(null, null);
    }

    private static class BasicSignature
    extends Signature {
        private final Class<? extends Cache> cacheInterface = this.getImplementationClass("com.maxifier.mxcache.caches.", "Cache");
        private final Class<? extends Storage> storageInterface = this.getImplementationClass("com.maxifier.mxcache.storage.", "Storage");
        private final Class<?> calculatableInterface = this.getImplementationClass("com.maxifier.mxcache.caches.", "Calculatable");
        private final Class<? extends ElementLockedStorage> elementLockedStorageInterface = this.getImplementationClass("com.maxifier.mxcache.storage.elementlocked.", "ElementLockedStorage");
        private final Class<? extends SingletonDependencyNode> singletonDependencyNode;
        private final Class<? extends MultipleDependencyNode> multipleDependencyNode;

        BasicSignature(Class key, Class value) {
            super(key, value);
            this.singletonDependencyNode = key == null ? this.getImplementationClass(Signature.SINGLETON_NODES_PACKAGE_NAME, "DependencyNode") : null;
            this.multipleDependencyNode = key == null ? this.getImplementationClass(Signature.MULTIPLE_NODES_PACKAGE_NAME, "DependencyNode") : null;
        }

        @Override
        public Class<? extends Cache> getCacheInterface() {
            return this.cacheInterface;
        }

        @Override
        public Class<? extends Storage> getStorageInterface() {
            return this.storageInterface;
        }

        @Override
        public Class<?> getCalculableInterface() {
            return this.calculatableInterface;
        }

        @Override
        public Class<? extends ElementLockedStorage> getElementLockedStorageInterface() {
            return this.elementLockedStorageInterface;
        }

        @Override
        public Class<? extends SingletonDependencyNode> getSingletonDependencyNodeInterface() {
            return this.singletonDependencyNode;
        }

        @Override
        public Class<? extends MultipleDependencyNode> getMultipleDependencyNodeInterface() {
            return this.multipleDependencyNode;
        }

        @Override
        public String getImplementationClassName(String prefix, String postfix) {
            return prefix + BasicSignature.toString(this.getContainer()) + BasicSignature.toString(this.getValue()) + postfix;
        }

        @Override
        public Class<?> getImplementationClass(String prefix, String postfix) {
            return BasicSignature.findClass(this.getImplementationClassName(prefix, postfix));
        }

        private static Class<?> findClass(String implName) {
            try {
                return Class.forName(implName);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("No implementation class found (suggested implementation: " + implName + ")");
            }
        }
    }
}

