/*
 * Decompiled with CFR 0.152.
 */
package com.maxifier.mxcache.proxy;

import com.maxifier.mxcache.proxy.MxProxy;
import com.maxifier.mxcache.proxy.MxProxyGenerator;
import com.maxifier.mxcache.proxy.Resolvable;
import java.io.Serializable;
import javax.annotation.Nonnull;

public class MxAbstractProxy<T, C extends Resolvable<T>>
extends MxProxy<T, C>
implements Serializable {
    @Nonnull
    protected final C value;
    private final Class<T> valueClass;
    private final Class<C> containerClass;

    protected MxAbstractProxy(@Nonnull C value, Class<T> valueClass, Class<C> containerClass) {
        this.value = value;
        this.valueClass = valueClass;
        this.containerClass = containerClass;
    }

    public String toString() {
        return "Proxy for <" + this.value.getValue() + ">";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MxAbstractProxy)) {
            return false;
        }
        MxAbstractProxy that = (MxAbstractProxy)o;
        return this.containerClass == that.containerClass && this.valueClass == that.valueClass && this.value.getValue().equals(that.value.getValue());
    }

    public int hashCode() {
        int result = this.value.getValue().hashCode();
        result = 31 * result + this.valueClass.hashCode();
        result = 31 * result + this.containerClass.hashCode();
        return result;
    }

    protected Object writeReplace() {
        return new WriteProxy<T, C>(this.value, this.valueClass, this.containerClass);
    }

    @Override
    @Nonnull
    public C getValue() {
        return this.value;
    }

    private static final class WriteProxy<T, C extends Resolvable<T>>
    implements Serializable {
        private static final long serialVersionUID = 43218791L;
        @Nonnull
        private C container;
        private Class<T> valueClass;
        private Class<C> containerClass;

        @Deprecated
        public WriteProxy() {
        }

        public WriteProxy(@Nonnull C container, Class<T> valueClass, Class<C> containerClass) {
            this.container = container;
            this.valueClass = valueClass;
            this.containerClass = containerClass;
        }

        public Object readResolve() {
            return MxProxyGenerator.getProxyFactory(this.valueClass, this.containerClass).createProxy(this.container);
        }
    }
}

