/*
 * Decompiled with CFR 0.152.
 */
package com.maxifier.mxcache.proxy;

import com.maxifier.mxcache.CacheFactory;
import com.maxifier.mxcache.NoSuchInstanceException;
import com.maxifier.mxcache.context.CacheContext;
import com.maxifier.mxcache.proxy.ProxyFactory;
import com.maxifier.mxcache.proxy.ProxyMappingKey;
import com.maxifier.mxcache.proxy.UseProxy;
import gnu.trove.map.hash.THashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ProxyManager {
    private static final Logger logger = LoggerFactory.getLogger(ProxyManager.class);
    private static final ProxyManager INSTANCE = new ProxyManager();
    private final Map<ProxyMappingKey, Class<? extends ProxyFactory>> mapping = new THashMap();

    private ProxyManager() {
    }

    public static ProxyManager getInstance() {
        return INSTANCE;
    }

    public ProxyFactory getProxyFactory(CacheContext context, Class owner, String name, String desc) {
        ProxyMappingKey key = new ProxyMappingKey(owner, name, desc);
        return this.getProxyFactory(context, key);
    }

    @Deprecated
    public ProxyFactory getProxyFactory(Class owner, String name, String desc) {
        return this.getProxyFactory(CacheFactory.getDefaultContext(), owner, name, desc);
    }

    private ProxyFactory getProxyFactory(CacheContext context, ProxyMappingKey key) {
        Class<? extends ProxyFactory> proxyFactoryClass = this.getProxyFactoryClass(key);
        if (proxyFactoryClass != null) {
            try {
                return context.getInstanceProvider().forClass(proxyFactoryClass);
            }
            catch (NoSuchInstanceException e) {
                logger.warn("Cannot create proxy factory for " + key, (Throwable)e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class<? extends ProxyFactory> getProxyFactoryClass(ProxyMappingKey key) {
        Map<ProxyMappingKey, Class<? extends ProxyFactory>> map = this.mapping;
        synchronized (map) {
            if (this.mapping.containsKey(key)) {
                return this.mapping.get(key);
            }
            UseProxy useProxy = key.getMethod().getAnnotation(UseProxy.class);
            if (useProxy == null) {
                logger.warn("Cannot create proxy factory for " + key + ": no @UseProxy");
                return null;
            }
            Class<? extends ProxyFactory> proxyFactoryClass = useProxy.value();
            this.mapping.put(key, proxyFactoryClass);
            return proxyFactoryClass;
        }
    }
}

