/*
 * Decompiled with CFR 0.152.
 */
package com.maxifier.mxcache.transform;

import com.maxifier.mxcache.asm.Type;
import com.maxifier.mxcache.asm.commons.GeneratorAdapter;
import com.maxifier.mxcache.provider.Signature;
import com.maxifier.mxcache.transform.TransformGenerator;
import com.maxifier.mxcache.util.ClassGenerator;
import javax.annotation.Nonnull;

public final class ChainedTransformGenerator
implements TransformGenerator {
    private final TransformGenerator first;
    private final TransformGenerator second;

    private ChainedTransformGenerator(@Nonnull TransformGenerator first, @Nonnull TransformGenerator second) {
        this.first = first;
        this.second = second;
    }

    @Override
    public void generateForward(Type thisType, int fieldIndex, GeneratorAdapter method) {
        this.first.generateForward(thisType, fieldIndex, method);
        this.second.generateForward(thisType, fieldIndex + this.first.getFieldCount(), method);
    }

    @Override
    public void generateBackward(Type thisType, int fieldIndex, GeneratorAdapter method) {
        this.second.generateBackward(thisType, fieldIndex + this.first.getFieldCount(), method);
        this.first.generateBackward(thisType, fieldIndex, method);
    }

    @Override
    public void generateFields(Type thisType, int fieldIndex, ClassGenerator writer) {
        this.first.generateFields(thisType, fieldIndex, writer);
        this.second.generateFields(thisType, fieldIndex + this.first.getFieldCount(), writer);
    }

    @Override
    public void generateAcquire(Type thisType, int fieldIndex, GeneratorAdapter ctor, int contextLocal) {
        this.first.generateAcquire(thisType, fieldIndex, ctor, contextLocal);
        this.second.generateAcquire(thisType, fieldIndex + this.first.getFieldCount(), ctor, contextLocal);
    }

    @Override
    public int getFieldCount() {
        return this.first.getFieldCount() + this.second.getFieldCount();
    }

    @Override
    public Class getTransformedType(Class in) {
        return this.second.getTransformedType(this.first.getTransformedType(in));
    }

    @Override
    public Signature transformKey(Signature in) {
        return this.second.transformKey(this.first.transformKey(in));
    }

    @Override
    public Signature transformValue(Signature in) {
        return this.second.transformValue(this.first.transformValue(in));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChainedTransformGenerator that = (ChainedTransformGenerator)o;
        return this.first.equals(that.first) && this.second.equals(that.second);
    }

    public int hashCode() {
        return 31 * this.first.hashCode() + this.second.hashCode();
    }

    public String toString() {
        return this.first + " -> " + this.second;
    }

    @Nonnull
    public static TransformGenerator chain(@Nonnull TransformGenerator a, @Nonnull TransformGenerator b) {
        if (a == NO_TRANSFORM) {
            return b;
        }
        if (b == NO_TRANSFORM) {
            return a;
        }
        return new ChainedTransformGenerator(a, b);
    }
}

