/*
 * Decompiled with CFR 0.152.
 */
package com.maxifier.mxcache.transform;

import com.maxifier.mxcache.asm.Type;
import com.maxifier.mxcache.asm.commons.GeneratorAdapter;
import com.maxifier.mxcache.asm.commons.Method;
import com.maxifier.mxcache.provider.Signature;
import com.maxifier.mxcache.transform.TransformGenerator;
import com.maxifier.mxcache.tuple.TupleGenerator;
import com.maxifier.mxcache.util.ClassGenerator;
import com.maxifier.mxcache.util.CodegenHelper;
import java.util.Arrays;

class TupleTransformGenerator
implements TransformGenerator {
    private final Class[] inTypes;
    private final Class[] outTypes;
    private final TransformGenerator[] transformGenerators;
    private final int fieldCount;
    private final Class tupleIn;
    private final Type tupleInType;
    private final Class container;
    private final Class tupleOut;
    private final Type tupleOutType;

    public TupleTransformGenerator(TransformGenerator[] transformGenerators, Class[] inTypes, Class[] outTypes) {
        this.transformGenerators = transformGenerators;
        this.outTypes = outTypes;
        this.inTypes = inTypes;
        this.tupleIn = TupleGenerator.getTupleClass(inTypes);
        this.tupleInType = Type.getType((Class)this.tupleIn);
        if (outTypes.length > 1) {
            this.tupleOut = TupleGenerator.getTupleClass(outTypes);
            this.tupleOutType = Type.getType((Class)this.tupleOut);
            this.container = this.tupleOut;
        } else {
            this.tupleOut = null;
            this.tupleOutType = null;
            this.container = outTypes.length == 0 ? null : outTypes[0];
        }
        this.fieldCount = TupleTransformGenerator.getFieldCount(transformGenerators);
    }

    private static int getFieldCount(TransformGenerator[] transformGenerators) {
        int fieldCount = 0;
        for (TransformGenerator transformGenerator : transformGenerators) {
            if (transformGenerator == null) continue;
            fieldCount += transformGenerator.getFieldCount();
        }
        return fieldCount;
    }

    @Override
    public void generateForward(Type thisType, int fieldIndex, GeneratorAdapter method) {
        method.checkCast(this.tupleInType);
        if (this.tupleOut != null) {
            method.newInstance(this.tupleOutType);
            method.dupX1();
            method.swap();
        }
        int j = 0;
        for (int i = 0; i < this.transformGenerators.length; ++i) {
            boolean last;
            TransformGenerator transformGenerator = this.transformGenerators[i];
            if (transformGenerator == TransformGenerator.IGNORE_TRANSFORM) continue;
            Type from = Type.getType((Class)this.inTypes[i]);
            Type to = Type.getType((Class)this.outTypes[j]);
            boolean bl = last = j == this.outTypes.length - 1;
            if (!last) {
                method.dup();
            }
            method.invokeVirtual(this.tupleInType, new Method("getElement" + i, CodegenHelper.erase(from), CodegenHelper.EMPTY_TYPES));
            if (CodegenHelper.isReferenceType(from)) {
                method.checkCast(from);
            }
            if (transformGenerator != null) {
                transformGenerator.generateForward(thisType, fieldIndex, method);
                fieldIndex += transformGenerator.getFieldCount();
            }
            if (!last) {
                method.swap(CodegenHelper.OBJECT_TYPE, to);
            }
            ++j;
        }
        if (this.tupleOut != null) {
            method.invokeConstructor(this.tupleOutType, new Method("<init>", Type.VOID_TYPE, CodegenHelper.toErasedTypes(this.outTypes)));
        }
    }

    @Override
    public void generateBackward(Type thisType, int fieldIndex, GeneratorAdapter method) {
        if (this.inTypes.length != this.outTypes.length) {
            throw new UnsupportedOperationException("There are ignored params");
        }
        method.checkCast(this.tupleOutType);
        method.newInstance(this.tupleInType);
        method.dupX1();
        method.swap();
        for (int i = 0; i < this.transformGenerators.length; ++i) {
            boolean last;
            TransformGenerator transformGenerator = this.transformGenerators[i];
            Type from = Type.getType((Class)this.outTypes[i]);
            Type to = Type.getType((Class)this.inTypes[i]);
            boolean bl = last = i == this.transformGenerators.length - 1;
            if (!last) {
                method.dup();
            }
            method.invokeVirtual(this.tupleOutType, new Method("getElement" + i, CodegenHelper.erase(from), CodegenHelper.EMPTY_TYPES));
            if (CodegenHelper.isReferenceType(from)) {
                method.checkCast(from);
            }
            if (transformGenerator != null) {
                transformGenerator.generateBackward(thisType, fieldIndex, method);
                fieldIndex += transformGenerator.getFieldCount();
            }
            if (last) continue;
            method.swap(CodegenHelper.OBJECT_TYPE, to);
        }
        method.invokeConstructor(this.tupleInType, new Method("<init>", Type.VOID_TYPE, CodegenHelper.toErasedTypes(this.inTypes)));
    }

    @Override
    public void generateFields(Type thisType, int fieldIndex, ClassGenerator writer) {
        for (TransformGenerator transformGenerator : this.transformGenerators) {
            if (transformGenerator == null) continue;
            transformGenerator.generateFields(thisType, fieldIndex, writer);
            fieldIndex += transformGenerator.getFieldCount();
        }
    }

    @Override
    public void generateAcquire(Type thisType, int fieldIndex, GeneratorAdapter ctor, int contextLocal) {
        for (TransformGenerator transformGenerator : this.transformGenerators) {
            if (transformGenerator == null) continue;
            transformGenerator.generateAcquire(thisType, fieldIndex, ctor, contextLocal);
            fieldIndex += transformGenerator.getFieldCount();
        }
    }

    @Override
    public int getFieldCount() {
        return this.fieldCount;
    }

    @Override
    public Class getTransformedType(Class in) {
        assert (in == this.tupleIn) : "Tuple type should match " + in + " and " + this.tupleIn;
        return this.container;
    }

    @Override
    public Signature transformKey(Signature in) {
        assert (in.getContainer() == this.tupleIn) : "Tuple type should match " + in + " and " + this.tupleIn;
        return new Signature(this.outTypes, this.container, in.getValue());
    }

    @Override
    public Signature transformValue(Signature in) {
        throw new UnsupportedOperationException("Value cannot be tuple transform");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TupleTransformGenerator that = (TupleTransformGenerator)o;
        return Arrays.equals(this.inTypes, that.inTypes) && Arrays.equals(this.transformGenerators, that.transformGenerators);
    }

    public int hashCode() {
        return 31 * Arrays.hashCode(this.inTypes) + Arrays.hashCode(this.transformGenerators);
    }

    public String toString() {
        return "tuple transform " + Arrays.toString(this.transformGenerators);
    }
}

