/*
 * Decompiled with CFR 0.152.
 */
package com.maxifier.mxcache.activity;

import com.maxifier.mxcache.activity.Activity;
import com.maxifier.mxcache.activity.ActivityListener;
import com.maxifier.mxcache.activity.ActivityScope;
import com.maxifier.mxcache.activity.ActivitySerializableImpl;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActivityImpl
implements Activity,
Serializable {
    private static final Logger logger = LoggerFactory.getLogger(ActivityImpl.class);
    private static final long serialVersionUID = 100L;
    @Nonnull
    private final String name;
    private int globalRuns;
    private List<ActivityListener> listeners;
    private transient ThreadLocal<Integer> local;

    public ActivityImpl(@Nonnull String name) {
        this.name = name;
    }

    private synchronized ThreadLocal<Integer> getLocal() {
        if (this.local == null) {
            this.local = new ThreadLocal();
        }
        return this.local;
    }

    @Override
    @Nonnull
    public String getName() {
        return this.name;
    }

    public Object writeReplace() throws ObjectStreamException {
        return new ActivitySerializableImpl(this);
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ActivityImpl that = (ActivityImpl)o;
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public void start(@Nonnull ActivityScope scope) {
        this.fireStarted(scope);
        switch (scope) {
            case GLOBAL: {
                this.startGlobal();
                break;
            }
            case THREAD_LOCAL: {
                this.startThreadLocal();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported activity scope: " + (Object)((Object)scope));
            }
        }
    }

    @Override
    public void finish(@Nonnull ActivityScope scope) {
        this.fireFinished(scope);
        switch (scope) {
            case GLOBAL: {
                this.finishGlobal();
                break;
            }
            case THREAD_LOCAL: {
                this.finishThreadLocal();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported activity scope: " + (Object)((Object)scope));
            }
        }
    }

    private void startThreadLocal() {
        ThreadLocal<Integer> local;
        Integer old = (local = this.getLocal()).get();
        local.set(old == null ? 1 : old + 1);
    }

    private void finishThreadLocal() {
        ThreadLocal<Integer> local = this.getLocal();
        Integer integer = local.get();
        if (integer == null || integer == 0) {
            throw new IllegalStateException("Activity was not runned in current thread");
        }
        local.set(integer - 1);
    }

    private synchronized void startGlobal() {
        ++this.globalRuns;
    }

    private synchronized void finishGlobal() {
        if (this.globalRuns == 0) {
            throw new IllegalStateException("Activity is not running global");
        }
        --this.globalRuns;
    }

    @Override
    public synchronized boolean isRunning() {
        if (this.globalRuns > 0) {
            return true;
        }
        Integer localRuns = this.getLocal().get();
        return localRuns != null && localRuns > 0;
    }

    private synchronized void fireStarted(ActivityScope scope) {
        if (this.listeners != null) {
            for (ActivityListener activity : this.listeners) {
                try {
                    activity.started(scope);
                }
                catch (Exception e) {
                    logger.error("Error in ActivityListener for " + this, (Throwable)e);
                }
            }
        }
    }

    private synchronized void fireFinished(ActivityScope scope) {
        if (this.listeners != null) {
            for (ActivityListener activity : this.listeners) {
                try {
                    activity.finished(scope);
                }
                catch (Exception e) {
                    logger.error("Error in ActivityListener for " + this, (Throwable)e);
                }
            }
        }
    }

    @Override
    public synchronized void addListener(ActivityListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<ActivityListener>();
        }
        this.listeners.add(listener);
    }

    @Override
    public synchronized void removeListener(ActivityListener listener) {
        if (this.listeners != null) {
            this.listeners.remove(listener);
        }
    }
}

