/*
 * Decompiled with CFR 0.152.
 */
package com.maxifier.mxcache.clean;

import com.maxifier.mxcache.Cached;
import com.maxifier.mxcache.NonInstrumentedCacheException;
import com.maxifier.mxcache.caches.Cache;
import com.maxifier.mxcache.caches.CleaningNode;
import com.maxifier.mxcache.clean.CacheCleaner;
import com.maxifier.mxcache.clean.ClassCacheIds;
import com.maxifier.mxcache.clean.ClassCleanableInstanceList;
import com.maxifier.mxcache.clean.Cleanable;
import com.maxifier.mxcache.clean.CleaningHelper;
import com.maxifier.mxcache.clean.CustomCleanableInstanceList;
import com.maxifier.mxcache.provider.CacheDescriptor;
import gnu.trove.map.hash.THashMap;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CleanableRegister
implements CacheCleaner {
    private static final Logger logger = LoggerFactory.getLogger(CleanableRegister.class);
    private final Map<Class<?>, ClassCleanableInstanceList<?>> classCleanMap = new THashMap();
    private final Map<String, CustomCleanableInstanceList> groupCleanMap = new THashMap();
    private final Map<String, CustomCleanableInstanceList> tagCleanMap = new THashMap();
    private static final Cleanable<?> EMPTY_CLEANABLE = new EmptyCleanable();

    public synchronized <T> void registerClass(Class<T> clazz, Cleanable<T> cleanable, @Nullable Map<String, ClassCacheIds> groups, @Nullable Map<String, ClassCacheIds> tags) {
        if (clazz.isInterface()) {
            throw new IllegalArgumentException("Interface could not have cached methods!");
        }
        ClassCleanableInstanceList<Object> superClassList = this.getClassList(clazz.getSuperclass());
        ClassCleanableInstanceList<Object> instanceList = new ClassCleanableInstanceList<Object>(superClassList, cleanable, groups, tags, clazz);
        ClassCleanableInstanceList<Object> oldValue = this.classCleanMap.put(clazz, instanceList);
        if (oldValue != null) {
            throw new IllegalStateException(clazz + " already registered");
        }
        for (Class<?> intf : clazz.getInterfaces()) {
            this.getInterfaceList(intf).addChild(instanceList);
        }
        if (groups != null) {
            CleanableRegister.registerByString(instanceList, this.groupCleanMap, groups);
        }
        if (tags != null) {
            CleanableRegister.registerByString(instanceList, this.tagCleanMap, tags);
        }
    }

    private synchronized ClassCleanableInstanceList<Object> getClassList(Class cls) {
        if (cls == Object.class) {
            return null;
        }
        assert (!cls.isInterface());
        ClassCleanableInstanceList<Object> list = this.classCleanMap.get(cls);
        if (list == null) {
            list = new ClassCleanableInstanceList<Object>(this.getClassList(cls.getSuperclass()), EMPTY_CLEANABLE, null, null, cls);
            this.classCleanMap.put(cls, list);
        }
        return list;
    }

    private synchronized ClassCleanableInstanceList<Object> getInterfaceList(Class cls) {
        assert (cls.isInterface());
        ClassCleanableInstanceList<Object> list = this.classCleanMap.get(cls);
        if (list == null) {
            list = new ClassCleanableInstanceList(null, EMPTY_CLEANABLE, null, null, cls);
            this.classCleanMap.put(cls, list);
        }
        return list;
    }

    private static <T> void registerByString(ClassCleanableInstanceList<T> instanceList, Map<String, CustomCleanableInstanceList> cacheMap, Map<String, ClassCacheIds> map) {
        for (Map.Entry<String, ClassCacheIds> entry : map.entrySet()) {
            ClassCacheIds value = entry.getValue();
            String key = entry.getKey();
            CustomCleanableInstanceList list = cacheMap.get(key);
            if (list == null) {
                list = new CustomCleanableInstanceList();
                cacheMap.put(key, list);
            }
            list.add(instanceList, value.getStaticIds(), value.getInstanceIds());
        }
    }

    public void registerInstance(Object o, Class<?> aClass) {
        ClassCleanableInstanceList<?> instanceList = this.getListByClass(aClass);
        if (instanceList == null) {
            throw new IllegalArgumentException(String.format("Object %s has no cache", o));
        }
        instanceList.add(o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Cache> getCaches(@Nonnull CacheDescriptor descriptor) {
        ClassCleanableInstanceList<?> list = this.getListByClass(descriptor.getOwnerClass());
        if (list == null) {
            logger.error("Unknown class required: " + descriptor.getOwnerClass());
            return Collections.emptyList();
        }
        Cleanable<?> cleanable = list.getCleanable();
        if (descriptor.isStatic()) {
            return Collections.singletonList(cleanable.getStaticCache(descriptor.getId()));
        }
        list.lock();
        try {
            if (list.isEmpty()) {
                List<Cache> list2 = Collections.emptyList();
                return list2;
            }
            ArrayList<Cache> instances = new ArrayList<Cache>(list.size());
            for (Object instance : list) {
                instances.add(cleanable.getInstanceCache(instance, descriptor.getId()));
            }
            ArrayList<Cache> arrayList = instances;
            return arrayList;
        }
        finally {
            list.unlock();
        }
    }

    private synchronized ClassCleanableInstanceList<?> getListByClass(Class<?> aClass) {
        return this.classCleanMap.get(aClass);
    }

    @Override
    public void clearCacheByInstances(Object ... o) {
        for (Object object : o) {
            this.clearCacheByInstance(object);
        }
    }

    @Override
    public void clearCacheByInstance(Object o) {
        for (Class<?> aClass = o.getClass(); aClass != null && aClass != Object.class; aClass = aClass.getSuperclass()) {
            ClassCleanableInstanceList<?> cleanableInstanceList = this.getListByClass(aClass);
            if (cleanableInstanceList == null) {
                continue;
            }
            cleanableInstanceList.clearCache(o);
            return;
        }
        CleanableRegister.checkNonInstrumentedCaches(o.getClass());
        throw new IllegalArgumentException(String.format("Object %s has no caches", o));
    }

    static void checkNonInstrumentedCaches(Class c) throws NonInstrumentedCacheException {
        while (c != null && c != Object.class) {
            for (Method m : c.getDeclaredMethods()) {
                if (m.getAnnotation(Cached.class) == null) continue;
                throw new NonInstrumentedCacheException(m);
            }
            c = c.getSuperclass();
        }
    }

    @Override
    public void clearInstanceByTag(Object o, String tag) {
        for (Class<?> aClass = o.getClass(); aClass != null && aClass != Object.class; aClass = aClass.getSuperclass()) {
            ClassCleanableInstanceList<?> cleanableInstanceList = this.getListByClass(aClass);
            if (cleanableInstanceList == null) {
                continue;
            }
            cleanableInstanceList.clearCacheByTag(o, tag);
            return;
        }
        CleanableRegister.checkNonInstrumentedCaches(o.getClass());
        throw new IllegalArgumentException(String.format("Object %s has no caches", o));
    }

    @Override
    public void clearInstanceByGroup(Object o, String group) {
        for (Class<?> aClass = o.getClass(); aClass != null && aClass != Object.class; aClass = aClass.getSuperclass()) {
            ClassCleanableInstanceList<?> cleanableInstanceList = this.getListByClass(aClass);
            if (cleanableInstanceList == null) {
                continue;
            }
            cleanableInstanceList.clearCacheByGroup(o, group);
            return;
        }
        CleanableRegister.checkNonInstrumentedCaches(o.getClass());
        throw new IllegalArgumentException(String.format("Object %s has no caches", o));
    }

    @Override
    public void clearCacheByClass(Class<?> aClass) {
        ClassCleanableInstanceList<?> instanceList = this.getListByClass(aClass);
        if (instanceList == null) {
            CleanableRegister.checkNonInstrumentedCaches(aClass);
            logger.warn("There is no subclasses of " + aClass + " with caches yet");
            return;
        }
        instanceList.clearCache();
    }

    @Override
    public void clearCacheByGroup(String group) {
        CustomCleanableInstanceList list = this.getListByGroup(group);
        if (list != null) {
            list.clearCache();
        } else {
            logger.warn("There is no caches of group <" + group + "> yet");
        }
    }

    private synchronized CustomCleanableInstanceList getListByGroup(String group) {
        return this.groupCleanMap.get(group);
    }

    @Override
    public void clearCacheByTag(String tag) {
        CustomCleanableInstanceList list = this.getListByTag(tag);
        if (list != null) {
            list.clearCache();
        } else {
            logger.warn("There is no caches with tag <" + tag + "> yet");
        }
    }

    private synchronized CustomCleanableInstanceList getListByTag(String tag) {
        return this.tagCleanMap.get(tag);
    }

    @Override
    public void clearAll(Collection<? extends CleaningNode> elements) {
        CleaningHelper.lockAndClear(elements);
    }

    @Override
    public void clearCacheByAnnotation(Class<? extends Annotation> annotationClass) {
        CustomCleanableInstanceList list = this.getListByTag("@" + annotationClass.getName());
        if (list != null) {
            list.clearCache();
        } else {
            logger.warn("Can`t find cache for annotation " + annotationClass);
        }
    }

    private static class EmptyCleanable
    implements Cleanable<Object> {
        private EmptyCleanable() {
        }

        @Override
        public void appendStaticCachesTo(List<CleaningNode> locks) {
        }

        @Override
        public void appendInstanceCachesTo(List<CleaningNode> locks, Object o) {
        }

        @Override
        public Cache getStaticCache(int id) {
            throw new IllegalArgumentException("Interface has no caches");
        }

        @Override
        public Cache getInstanceCache(Object o, int id) {
            throw new IllegalArgumentException("Interface has no caches");
        }
    }
}

