/*
 * Decompiled with CFR 0.152.
 */
package com.maxifier.mxcache.clean;

import com.maxifier.mxcache.caches.CleaningNode;
import com.maxifier.mxcache.clean.ClassCleanableInstanceList;
import com.maxifier.mxcache.clean.Cleanable;
import com.maxifier.mxcache.clean.CleanableInstanceList;
import com.maxifier.mxcache.clean.CleaningHelper;
import com.maxifier.mxcache.clean.WeakList;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

final class CustomCleanableInstanceList
implements CleanableInstanceList {
    private final List<CustomClassCleanableInstanceList<?>> list = new ArrayList();
    private final Lock readLock;
    private final Lock writeLock;
    private volatile int version;

    public CustomCleanableInstanceList() {
        ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
        this.readLock = readWriteLock.readLock();
        this.writeLock = readWriteLock.writeLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void add(ClassCleanableInstanceList<T> classList, int[] classIds, int[] instanceIds) {
        this.writeLock.lock();
        try {
            ++this.version;
            this.list.add(new CustomClassCleanableInstanceList<T>(classList, classIds, instanceIds));
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void clearCache() {
        CleaningHelper.clear(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getCaches(List<CleaningNode> caches) {
        this.readLock.lock();
        try {
            for (CustomClassCleanableInstanceList<?> customClassCleanableInstanceList : this.list) {
                customClassCleanableInstanceList.getCaches(caches);
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void deepUnlock() {
        this.readLock.unlock();
    }

    @Override
    public int deepLock() {
        this.readLock.lock();
        return this.version;
    }

    @Override
    public void getLists(List<WeakList<?>> lists) {
        for (CustomClassCleanableInstanceList<?> customClassCleanableInstanceList : this.list) {
            lists.add(((CustomClassCleanableInstanceList)customClassCleanableInstanceList).classList);
        }
    }

    private static class CustomClassCleanableInstanceList<T> {
        private final ClassCleanableInstanceList<T> classList;
        private final int[] staticIds;
        private final int[] instanceIds;

        public CustomClassCleanableInstanceList(ClassCleanableInstanceList<T> classList, int[] staticIds, int[] instanceIds) {
            this.classList = classList;
            this.staticIds = staticIds;
            this.instanceIds = instanceIds;
        }

        public void getCaches(List<CleaningNode> caches) {
            Cleanable cleanable = this.classList.getCleanable();
            for (int id : this.staticIds) {
                caches.add(cleanable.getStaticCache(id));
            }
            for (Object t : this.classList) {
                for (int id : this.instanceIds) {
                    caches.add(cleanable.getInstanceCache(t, id));
                }
            }
        }
    }
}

