/*
 * Decompiled with CFR 0.152.
 */
package com.maxifier.mxcache.clean;

import com.maxifier.mxcache.LightweightLock;
import com.maxifier.mxcache.util.TIdentityHashSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.locks.Lock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SuperLock {
    private static final Logger logger = LoggerFactory.getLogger(SuperLock.class);
    private final LightweightLock masterLock;
    private final Lock[] locks;
    private int n;

    public SuperLock(Collection<? extends Lock> locks) {
        this(locks.toArray(new Lock[locks.size()]));
    }

    public SuperLock(Lock[] locks) {
        this.locks = locks;
        this.masterLock = new LightweightLock();
    }

    protected void finalize() throws Throwable {
        if (this.n != 0) {
            logger.error("MxCache hasn't released {} locks: {}", (Object)this.n, (Object)Arrays.toString(this.locks));
        }
        super.finalize();
    }

    public void lock() {
        this.masterLock.lock();
        int i = 0;
        int firstLockedIndex = 0;
        if (this.n != 0) {
            throw new IllegalMonitorStateException("SuperLock already locked");
        }
        for (int locked = 0; locked < this.locks.length; ++locked) {
            Lock lock = this.locks[i];
            if (lock.tryLock()) continue;
            while (locked > 0) {
                this.locks[firstLockedIndex++].unlock();
                if (firstLockedIndex == this.locks.length) {
                    firstLockedIndex = 0;
                }
                --locked;
            }
            lock.lock();
            if (++i != this.locks.length) continue;
            i = 0;
        }
        this.n = this.locks.length;
    }

    public void unlock() {
        if (this.n > 0) {
            for (int i = 0; i < this.n; ++i) {
                this.locks[i].unlock();
            }
            this.n = 0;
        }
        this.masterLock.unlock();
    }

    public void unlockPartially(TIdentityHashSet<Lock> locksToRelease) {
        int i;
        if (!this.masterLock.isHeldByCurrentThread()) {
            throw new IllegalMonitorStateException("Lock must be held by current thread");
        }
        int to = 0;
        for (i = 0; i < this.n; ++i) {
            Lock lock = this.locks[i];
            if (locksToRelease.contains(lock)) {
                lock.unlock();
                continue;
            }
            this.locks[to++] = lock;
        }
        for (i = to; i < this.n; ++i) {
            this.locks[i] = null;
        }
        if (this.n - to != locksToRelease.size()) {
            throw new IllegalArgumentException("Unknown locks are passed to unlockPartially()");
        }
        this.n = to;
    }
}

