/*
 * Decompiled with CFR 0.152.
 */
package com.maxifier.mxcache.config;

import com.maxifier.mxcache.DependencyTracking;
import com.maxifier.mxcache.Strategy;
import com.maxifier.mxcache.config.Rule;
import com.maxifier.mxcache.config.StrategyProperty;
import com.maxifier.mxcache.provider.CachingStrategy;
import com.maxifier.mxcache.resource.ResourceDependency;
import com.maxifier.mxcache.resource.TrackDependency;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JaxbRule
implements Rule {
    private static final Logger logger = LoggerFactory.getLogger(JaxbRule.class);
    @XmlAttribute
    private boolean disabled;
    @XmlElement
    private Boolean disableCache;
    @XmlTransient
    private boolean disableCacheImportant;
    @XmlAttribute
    private boolean important;
    @XmlElement
    private DependencyTracking trackDependency = DependencyTracking.DEFAULT;
    @XmlTransient
    private boolean trackImportant;
    @XmlElement(name="resourceDependency")
    private Set<String> resourceDependencies;
    @XmlElement(name="strategy")
    private String strategyClassName;
    @XmlElement(name="cacheName")
    private String cacheName;
    @XmlTransient
    private boolean cacheNameImportant;
    @XmlTransient
    private Class<? extends CachingStrategy> strategy;
    @XmlTransient
    private boolean strategyImportant;
    @XmlElement(name="property")
    private List<StrategyProperty> properties;
    @XmlTransient
    private final Set<String> ruleNames = new THashSet();
    @XmlTransient
    private final Map<String, PropertyValueImpl> propertyMap = new THashMap();

    JaxbRule() {
    }

    @Override
    public void override(Method method, String cacheName) {
        ResourceDependency dependency;
        TrackDependency trackDependency;
        Strategy annotatedStrategy;
        if (!this.cacheNameImportant && cacheName != null) {
            this.cacheName = cacheName;
        }
        if (!this.strategyImportant && (annotatedStrategy = method.getAnnotation(Strategy.class)) != null) {
            this.strategy = annotatedStrategy.value();
        }
        if (!this.trackImportant && (trackDependency = method.getAnnotation(TrackDependency.class)) != null) {
            this.trackDependency = trackDependency.value();
        }
        if ((dependency = method.getAnnotation(ResourceDependency.class)) != null) {
            if (this.resourceDependencies == null) {
                this.resourceDependencies = new THashSet();
            }
            Collections.addAll(this.resourceDependencies, dependency.value());
        }
    }

    void override(JaxbRule rule) {
        this.overrideTrackDependency(rule);
        this.overrideDisableCache(rule);
        this.overrideStrategyClassName(rule);
        this.overrideCacheName(rule);
        this.overrideResourceDependencies(rule);
        this.overrideProperties(rule);
    }

    private void overrideResourceDependencies(JaxbRule rule) {
        if (rule.resourceDependencies != null) {
            if (this.resourceDependencies == null) {
                this.resourceDependencies = rule.resourceDependencies;
            } else {
                this.resourceDependencies.addAll(rule.resourceDependencies);
            }
        }
    }

    private void overrideTrackDependency(JaxbRule rule) {
        if (rule.trackDependency != DependencyTracking.DEFAULT && (!this.trackImportant || rule.important)) {
            this.trackDependency = rule.trackDependency;
            this.trackImportant = rule.important;
        }
    }

    private void overrideCacheName(JaxbRule rule) {
        if (rule.cacheName != null && (!this.cacheNameImportant || rule.important)) {
            this.cacheName = rule.cacheName;
            this.cacheNameImportant = rule.important;
        }
    }

    private void overrideStrategyClassName(JaxbRule rule) {
        if (rule.strategyClassName != null && (!this.strategyImportant || rule.important)) {
            this.strategyClassName = rule.strategyClassName;
            this.strategyImportant = rule.important;
        }
    }

    private void overrideDisableCache(JaxbRule rule) {
        if (rule.disableCache != null && (!this.disableCacheImportant || rule.important)) {
            this.disableCache = rule.disableCache;
            this.disableCacheImportant = rule.important;
        }
    }

    private void overrideProperties(JaxbRule rule) {
        if (rule.properties != null) {
            for (StrategyProperty property : rule.properties) {
                boolean set;
                String name = property.getName();
                PropertyValueImpl oldProperty = this.propertyMap.get(name);
                Object value = this.getValue(rule, property);
                if (oldProperty == null) {
                    oldProperty = new PropertyValueImpl();
                    this.propertyMap.put(name, oldProperty);
                    set = true;
                } else {
                    boolean bl = set = !oldProperty.important || rule.important;
                }
                if (!set) continue;
                oldProperty.important = rule.important;
                oldProperty.value = value;
            }
        }
    }

    private Object getValue(JaxbRule rule, StrategyProperty property) {
        List<String> valueList = property.getValues();
        String stringValue = property.getValue();
        if (valueList != null) {
            if (stringValue != null) {
                valueList = new ArrayList<String>(valueList);
                valueList.add(stringValue);
                logger.error("Invalid configuration for rule " + rule + ": value and values both exist " + property.getName());
            }
            return valueList;
        }
        if (stringValue != null) {
            return stringValue;
        }
        logger.error("Invalid configuration for rule " + rule + ": empty property " + property.getName());
        return null;
    }

    @Override
    public Object getProperty(String name) {
        PropertyValueImpl value = this.propertyMap.get(name);
        return value == null ? null : value.value;
    }

    @Override
    public boolean isImportantProperty(String name) {
        PropertyValueImpl value = this.propertyMap.get(name);
        return value != null && value.important;
    }

    @Override
    public DependencyTracking getTrackDependency() {
        return this.trackDependency;
    }

    @Override
    public Set<String> getResourceDependencies() {
        return this.resourceDependencies == null ? Collections.emptySet() : this.resourceDependencies;
    }

    @Override
    public Set<String> getRuleNames() {
        return this.ruleNames;
    }

    void addRuleName(String name) {
        this.ruleNames.add(name);
    }

    @Override
    public Class<? extends CachingStrategy> getStrategy() {
        if (this.strategy != null) {
            return this.strategy;
        }
        if (this.strategyClassName == null) {
            return null;
        }
        try {
            return Class.forName(this.strategyClassName);
        }
        catch (ClassNotFoundException c) {
            logger.error("Invalid configuration: unknown strategy class " + this.strategyClassName);
            return null;
        }
    }

    @Override
    public String getCacheName() {
        return this.cacheName;
    }

    @Override
    public boolean getDisableCache() {
        return this.disableCache != null && this.disableCache != false;
    }

    public String getName() {
        return this.getRuleNames().toString();
    }

    public String toString() {
        return "rule:" + this.getName();
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    private static class PropertyValueImpl {
        boolean important;
        Object value;

        private PropertyValueImpl() {
        }
    }
}

