/*
 * Decompiled with CFR 0.152.
 */
package com.maxifier.mxcache.config;

import com.maxifier.mxcache.config.ResourceConfig;
import com.maxifier.mxcache.config.RuleWithSelector;
import gnu.trove.set.hash.THashSet;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="mxcache")
final class MxCacheConfig {
    @XmlElement(name="resource")
    private final List<ResourceConfig> resources = new ArrayList<ResourceConfig>();
    @XmlElement(name="rule")
    private final List<RuleWithSelector> rules = new ArrayList<RuleWithSelector>();
    private final Set<String> sources = new THashSet();

    MxCacheConfig() {
    }

    void setSource(String source) {
        for (RuleWithSelector rule : this.rules) {
            rule.setSource(source);
        }
    }

    public List<ResourceConfig> getResources() {
        return this.resources;
    }

    public List<RuleWithSelector> getRules() {
        return this.rules;
    }

    public void addSource(URL url) {
        this.sources.add(url.toExternalForm());
    }

    public boolean hasSource(URL url) {
        return this.sources.contains(url.toExternalForm());
    }

    void merge(MxCacheConfig config) {
        this.resources.addAll(config.resources);
        this.sources.addAll(config.sources);
        for (RuleWithSelector rule : config.rules) {
            if (rule.isDisabled()) continue;
            this.rules.add(rule);
        }
    }
}

