/*
 * Decompiled with CFR 0.152.
 */
package com.maxifier.mxcache.hashing;

import com.maxifier.mxcache.context.CacheContext;
import com.maxifier.mxcache.hashing.HashingStrategyFactory;
import com.maxifier.mxcache.hashing.TupleHashingStrategy;
import gnu.trove.strategy.HashingStrategy;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHashingStrategyFactory
implements HashingStrategyFactory {
    private static final Logger logger = LoggerFactory.getLogger(AbstractHashingStrategyFactory.class);

    @Override
    public Object createHashingStrategy(CacheContext context, Method method) {
        Class[] paramTypes = method.getParameterTypes();
        if (paramTypes.length == 0) {
            return null;
        }
        Annotation[][] paramAnnotations = method.getParameterAnnotations();
        if (paramTypes.length > 1) {
            return this.createTupleHashingStrategy(context, paramTypes, paramAnnotations);
        }
        return this.createValueHashingStrategy(context, paramTypes[0], paramAnnotations[0]);
    }

    private Object createValueHashingStrategy(CacheContext context, Class paramType, Annotation[] paramAnnotation) {
        Object strategy = this.findStrategyClass(context, paramType, paramAnnotation);
        if (strategy == null || !this.isSuitableStrategy(paramType, strategy)) {
            return null;
        }
        return strategy;
    }

    private boolean isSuitableStrategy(Class paramType, Object strategy) {
        if (paramType.isPrimitive()) {
            logger.error("Param of type " + paramType + " cannot have strategy");
            return false;
        }
        if (!HashingStrategy.class.isInstance(strategy)) {
            logger.error("Param of type " + paramType + " cannot have strategy of type " + strategy);
            return false;
        }
        return true;
    }

    private HashingStrategy createTupleHashingStrategy(CacheContext context, Class[] paramTypes, Annotation[][] paramAnnotations) {
        Object[] strategies = new Object[paramAnnotations.length];
        int n = 0;
        for (int i = 0; i < paramAnnotations.length; ++i) {
            Object strategy = this.createValueHashingStrategy(context, paramTypes[i], paramAnnotations[i]);
            if (strategy != null) {
                ++n;
            }
            strategies[i] = strategy;
        }
        return n > 0 ? new TupleHashingStrategy(strategies) : null;
    }

    protected abstract Object findStrategyClass(CacheContext var1, Class var2, Annotation[] var3);
}

