/*
 * Decompiled with CFR 0.152.
 */
package com.maxifier.mxcache.hashing;

import com.maxifier.mxcache.NoSuchInstanceException;
import com.maxifier.mxcache.context.CacheContext;
import com.maxifier.mxcache.hashing.AbstractHashingStrategyFactory;
import com.maxifier.mxcache.hashing.ArrayHashingStrategy;
import com.maxifier.mxcache.hashing.BooleanArrayHashingStrategy;
import com.maxifier.mxcache.hashing.ByteArrayHashingStrategy;
import com.maxifier.mxcache.hashing.CharArrayHashingStrategy;
import com.maxifier.mxcache.hashing.DoubleArrayHashingStrategy;
import com.maxifier.mxcache.hashing.FloatArrayHashingStrategy;
import com.maxifier.mxcache.hashing.HashingStrategy;
import com.maxifier.mxcache.hashing.IdentityHashing;
import com.maxifier.mxcache.hashing.IntArrayHashingStrategy;
import com.maxifier.mxcache.hashing.LongArrayHashingStrategy;
import com.maxifier.mxcache.hashing.ShortArrayHashingStrategy;
import gnu.trove.strategy.IdentityHashingStrategy;
import java.lang.annotation.Annotation;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultHashingStrategyFactory
extends AbstractHashingStrategyFactory {
    private static final Logger logger = LoggerFactory.getLogger(DefaultHashingStrategyFactory.class);
    private static final DefaultHashingStrategyFactory INSTANCE = new DefaultHashingStrategyFactory();

    public static DefaultHashingStrategyFactory getInstance() {
        return INSTANCE;
    }

    private DefaultHashingStrategyFactory() {
    }

    @Override
    protected Object findStrategyClass(CacheContext context, Class paramType, Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            if (annotation instanceof HashingStrategy) {
                return this.instantiate(context, ((HashingStrategy)annotation).value());
            }
            if (!(annotation instanceof IdentityHashing)) continue;
            if (paramType.isPrimitive()) {
                throw new UnsupportedOperationException();
            }
            if (paramType.isArray()) {
                return null;
            }
            return new IdentityHashingStrategy();
        }
        if (paramType.isArray()) {
            return this.getArrayHashingStrategy(paramType);
        }
        return null;
    }

    @Nullable
    protected <T> T instantiate(CacheContext context, Class<T> strategyClass) {
        try {
            return context.getInstanceProvider().forClass(strategyClass);
        }
        catch (NoSuchInstanceException e) {
            logger.error("Cannot instantiate strategy of type " + strategyClass, (Throwable)e);
            return null;
        }
    }

    private gnu.trove.strategy.HashingStrategy getArrayHashingStrategy(Class paramType) {
        if (paramType == boolean[].class) {
            return BooleanArrayHashingStrategy.getInstance();
        }
        if (paramType == byte[].class) {
            return ByteArrayHashingStrategy.getInstance();
        }
        if (paramType == char[].class) {
            return CharArrayHashingStrategy.getInstance();
        }
        if (paramType == short[].class) {
            return ShortArrayHashingStrategy.getInstance();
        }
        if (paramType == int[].class) {
            return IntArrayHashingStrategy.getInstance();
        }
        if (paramType == long[].class) {
            return LongArrayHashingStrategy.getInstance();
        }
        if (paramType == float[].class) {
            return FloatArrayHashingStrategy.getInstance();
        }
        if (paramType == double[].class) {
            return DoubleArrayHashingStrategy.getInstance();
        }
        if (paramType.isArray()) {
            return ArrayHashingStrategy.getInstance();
        }
        throw new UnsupportedOperationException();
    }
}

