/*
 * Decompiled with CFR 0.152.
 */
package com.maxifier.mxcache.impl;

import com.maxifier.mxcache.caches.Cache;
import com.maxifier.mxcache.caches.Calculable;
import com.maxifier.mxcache.context.CacheContext;
import com.maxifier.mxcache.impl.CacheId;
import com.maxifier.mxcache.impl.CacheProviderInterceptorChain;
import com.maxifier.mxcache.impl.RegistryEntry;
import com.maxifier.mxcache.mbean.CacheControl;
import com.maxifier.mxcache.provider.CacheDescriptor;
import com.maxifier.mxcache.provider.CacheManager;
import com.maxifier.mxcache.provider.CacheProvider;
import com.maxifier.mxcache.provider.CacheProviderInterceptor;
import gnu.trove.map.hash.THashMap;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.management.InstanceAlreadyExistsException;
import javax.management.JMException;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheProviderImpl
implements CacheProvider {
    private static final Logger logger = LoggerFactory.getLogger(CacheProviderImpl.class);
    private final Map<CacheId, RegistryEntry> registry = new THashMap();
    private final CacheProviderInterceptorChain interceptorChain = new CacheProviderInterceptorChain();

    public CacheProviderImpl() {
        this(true);
    }

    public CacheProviderImpl(boolean needsMBean) {
        if (needsMBean) {
            CacheProviderImpl.registerMBean(new CacheControl(this), "com.maxifier.mxcache:service=CacheControl");
        }
    }

    @Override
    public void intercept(CacheProviderInterceptor interceptor) {
        this.interceptorChain.add(interceptor);
    }

    @Override
    public boolean removeInterceptor(CacheProviderInterceptor interceptor) {
        return this.interceptorChain.remove(interceptor);
    }

    public static void registerMBean(Object mbean, String name) {
        try {
            try {
                ManagementFactory.getPlatformMBeanServer().registerMBean(mbean, new ObjectName(name));
            }
            catch (InstanceAlreadyExistsException e) {
                logger.warn("MxCache MBean is already registered ({}), will use unique name fallback", (Object)name, (Object)e.getMessage());
                ManagementFactory.getPlatformMBeanServer().registerMBean(mbean, new ObjectName(name + "-" + UUID.randomUUID()));
            }
        }
        catch (JMException e) {
            logger.error("Cannot register MxCache mbean", (Throwable)e);
        }
    }

    @Override
    public synchronized <T> void registerCache(Class<T> cacheOwner, int cacheId, Class key, Class value, String group, String[] tags, Calculable calculable, String methodName, String methodDesc, String cacheName) {
        if (logger.isTraceEnabled()) {
            logger.trace("Register: owner = {}, method = {}, name = {}, id = {}, type = {} -> {}, group = {}, tags = {}", new Object[]{cacheOwner, methodName + methodDesc, cacheName, cacheId, key, value, group, Arrays.toString(tags)});
        }
        CacheDescriptor<T> descriptor = new CacheDescriptor<T>(cacheOwner, cacheId, key, value, calculable, methodName, methodDesc, cacheName, group, tags, null);
        descriptor = this.interceptorChain.registerCache(descriptor);
        RegistryEntry<T> entry = new RegistryEntry<T>(descriptor);
        this.registry.put(new CacheId(cacheOwner, cacheId), entry);
    }

    @Override
    public synchronized Cache createCache(@Nonnull Class cacheOwner, int cacheId, @Nullable Object instance, CacheContext context) {
        RegistryEntry registryEntry;
        if (logger.isTraceEnabled()) {
            logger.trace("createCache({}, {}, {})", new Object[]{cacheOwner, cacheId, instance});
        }
        if ((registryEntry = this.registry.get(new CacheId(cacheOwner, cacheId))) == null) {
            throw new IllegalStateException("Unknown cache: " + cacheOwner + " # " + cacheId);
        }
        Cache res = registryEntry.createCache(context, instance);
        res = this.interceptorChain.createCache(registryEntry, instance, context, res);
        return res;
    }

    @Override
    public synchronized CacheDescriptor getDescriptor(CacheId id) {
        if (id == null) {
            return null;
        }
        RegistryEntry entry = this.registry.get(id);
        if (entry == null) {
            return null;
        }
        return entry.getDescriptor();
    }

    @Override
    public synchronized List<CacheManager> getCaches() {
        ArrayList<CacheManager> res = new ArrayList<CacheManager>(this.registry.size());
        for (RegistryEntry registryEntry : this.registry.values()) {
            res.addAll(registryEntry.getManagers());
        }
        return res;
    }
}

