/*
 * Decompiled with CFR 0.152.
 */
package com.maxifier.mxcache.impl;

import com.maxifier.mxcache.caches.Cache;
import com.maxifier.mxcache.context.CacheContext;
import com.maxifier.mxcache.impl.CacheProviderImpl;
import com.maxifier.mxcache.impl.RegistryEntry;
import com.maxifier.mxcache.provider.CacheDescriptor;
import com.maxifier.mxcache.provider.CacheProviderInterceptor;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class CacheProviderInterceptorChain
implements CacheProviderInterceptor {
    private final List<CacheProviderInterceptor> interceptors = new ArrayList<CacheProviderInterceptor>();
    private static final Logger logger = LoggerFactory.getLogger(CacheProviderImpl.class);

    CacheProviderInterceptorChain() {
    }

    public synchronized void add(CacheProviderInterceptor interceptor) {
        if (interceptor == null) {
            throw new IllegalArgumentException("Null interceptor");
        }
        this.interceptors.add(interceptor);
    }

    public synchronized boolean remove(CacheProviderInterceptor interceptor) {
        return this.interceptors.remove(interceptor);
    }

    @Override
    @Nonnull
    public synchronized <T> CacheDescriptor<T> registerCache(CacheDescriptor<T> descriptor) {
        CacheDescriptor<T> res = descriptor;
        for (CacheProviderInterceptor interceptor : this.interceptors) {
            try {
                CacheDescriptor<T> override = interceptor.registerCache(res);
                if (override == null) continue;
                res = override;
            }
            catch (RuntimeException e) {
                logger.error("Exception in registerCache(" + descriptor + ") in interceptor " + interceptor, (Throwable)e);
            }
        }
        return res;
    }

    @Override
    @Nonnull
    public synchronized <T> Cache createCache(RegistryEntry<T> registryEntry, @Nullable T instance, CacheContext context, Cache cache) {
        Cache res = cache;
        for (CacheProviderInterceptor interceptor : this.interceptors) {
            try {
                Cache override = interceptor.createCache(registryEntry, instance, context, res);
                if (override == null) continue;
                res = override;
            }
            catch (RuntimeException e) {
                logger.error("Exception in createCache(" + registryEntry.getDescriptor(), (Object)(" <instance>, " + context + ", " + cache + ") in interceptor " + interceptor), (Object)e);
            }
        }
        return res;
    }
}

