/*
 * Decompiled with CFR 0.152.
 */
package com.maxifier.mxcache.impl;

import com.maxifier.mxcache.context.CacheContext;
import com.maxifier.mxcache.provider.CacheDescriptor;
import com.maxifier.mxcache.provider.StorageFactory;
import com.maxifier.mxcache.storage.Storage;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CustomStorageFactory<T>
implements StorageFactory<T> {
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private final Constructor<? extends Storage> constructor;
    private final Object[] arguments;

    public CustomStorageFactory(CacheContext context, CacheDescriptor<T> descriptor, Class<? extends Storage> storageClass) {
        if (!Storage.class.isAssignableFrom(storageClass)) {
            throw new IllegalStateException("Storage implementation should extend Storage interface " + storageClass);
        }
        this.constructor = CustomStorageFactory.getCustomConstructor(storageClass);
        if (this.constructor == null) {
            throw new IllegalStateException("Storage should have constructor taking CacheDescriptor, CacheContext or both: " + storageClass);
        }
        this.arguments = CustomStorageFactory.createArguments(this.constructor, context, descriptor);
    }

    private static boolean isAllowedConstructorArgumentType(Class type) {
        return type == CacheDescriptor.class || type == CacheContext.class;
    }

    private static boolean isAllowedConstructorArgumentTypes(Class[] types) {
        for (Class type : types) {
            if (CustomStorageFactory.isAllowedConstructorArgumentType(type)) continue;
            return false;
        }
        return true;
    }

    @Override
    @Nonnull
    public Storage createStorage(T owner) throws InvocationTargetException, IllegalAccessException, InstantiationException {
        return this.constructor.newInstance(this.arguments);
    }

    @Override
    public String getImplementationDetails() {
        return this.constructor.getDeclaringClass().getCanonicalName();
    }

    @Nullable
    static <T> Constructor<? extends T> getCustomConstructor(Class<? extends T> cls) {
        Constructor<?>[] constructors = cls.getDeclaredConstructors();
        Constructor<?> res = null;
        int n = 0;
        for (Constructor<?> constructor : constructors) {
            Class[] types = constructor.getParameterTypes();
            if (!CustomStorageFactory.isAllowedConstructorArgumentTypes(types) || res != null && n >= types.length) continue;
            res = constructor;
            n = types.length;
        }
        return res;
    }

    static <T> Object[] createArguments(Constructor<? extends T> constructor, CacheContext context, CacheDescriptor<?> descriptor) {
        Class<?>[] types = constructor.getParameterTypes();
        if (types.length == 0) {
            return EMPTY_ARRAY;
        }
        Object[] res = new Object[types.length];
        for (int i = 0; i < types.length; ++i) {
            assert (CustomStorageFactory.isAllowedConstructorArgumentType(types[i]));
            res[i] = types[i] == CacheDescriptor.class ? descriptor : context;
        }
        return res;
    }
}

