/*
 * Decompiled with CFR 0.152.
 */
package com.maxifier.mxcache.impl;

import com.maxifier.mxcache.context.CacheContext;
import com.maxifier.mxcache.hashing.DefaultHashingStrategyFactory;
import com.maxifier.mxcache.hashing.HashingStrategyFactory;
import com.maxifier.mxcache.impl.CustomStorageFactory;
import com.maxifier.mxcache.impl.DefaultStorageFactory;
import com.maxifier.mxcache.impl.StorageBasedCacheManager;
import com.maxifier.mxcache.provider.CacheDescriptor;
import com.maxifier.mxcache.provider.CacheManager;
import com.maxifier.mxcache.provider.CachingStrategy;
import com.maxifier.mxcache.provider.StorageFactory;
import java.lang.reflect.Constructor;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultStrategy
implements CachingStrategy {
    private static final Logger logger = LoggerFactory.getLogger(DefaultStrategy.class);
    private static final String CANNOT_INSTANTIATE_MESSAGE = "Cannot instantiate StorageFactory for %s (%s)";
    private static final DefaultStrategy INSTANCE = new DefaultStrategy();
    private final HashingStrategyFactory hashingStrategyFactory;

    public static DefaultStrategy getInstance() {
        return INSTANCE;
    }

    private DefaultStrategy() {
        this.hashingStrategyFactory = DefaultHashingStrategyFactory.getInstance();
    }

    public DefaultStrategy(HashingStrategyFactory hashingStrategyFactory) {
        this.hashingStrategyFactory = hashingStrategyFactory;
    }

    @Override
    @Nonnull
    public <T> CacheManager<T> getManager(CacheContext context, CacheDescriptor<T> descriptor) {
        return new StorageBasedCacheManager<T>(context, descriptor, new DefaultStorageFactory(context, this.hashingStrategyFactory, descriptor));
    }

    public <T> StorageFactory<T> getStorageFactory(CacheContext context, CacheDescriptor<T> descriptor, Class<? extends StorageFactory<T>> storageFactory) {
        if (storageFactory != DefaultStorageFactory.class) {
            if (StorageFactory.class.isAssignableFrom(storageFactory)) {
                Constructor<StorageFactory<T>> ctor = CustomStorageFactory.getCustomConstructor(storageFactory);
                Object[] arguments = CustomStorageFactory.createArguments(ctor, context, descriptor);
                try {
                    return ctor.newInstance(arguments);
                }
                catch (Exception e) {
                    logger.error(String.format(CANNOT_INSTANTIATE_MESSAGE, descriptor, storageFactory), (Throwable)e);
                }
            } else {
                logger.error("Invalid cache manager for " + descriptor + " (" + storageFactory + " is not StorageFactory)");
            }
        }
        return new DefaultStorageFactory(context, this.hashingStrategyFactory, descriptor);
    }
}

