/*
 * Decompiled with CFR 0.152.
 */
package com.maxifier.mxcache.impl;

import com.maxifier.mxcache.MxCacheException;
import com.maxifier.mxcache.asm.Type;
import com.maxifier.mxcache.asm.commons.Method;
import com.maxifier.mxcache.caches.Cache;
import com.maxifier.mxcache.context.CacheContext;
import com.maxifier.mxcache.impl.resource.DependencyNode;
import com.maxifier.mxcache.impl.resource.DependencyTracker;
import com.maxifier.mxcache.interfaces.Statistics;
import com.maxifier.mxcache.provider.CacheDescriptor;
import com.maxifier.mxcache.provider.CacheManager;
import com.maxifier.mxcache.provider.Signature;
import com.maxifier.mxcache.util.ClassGenerator;
import com.maxifier.mxcache.util.CodegenHelper;
import com.maxifier.mxcache.util.MxConstructorGenerator;
import com.maxifier.mxcache.util.MxField;
import com.maxifier.mxcache.util.MxGeneratorAdapter;
import gnu.trove.map.hash.THashMap;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import javax.annotation.Nullable;

public class NullCacheManager<T>
implements CacheManager<T> {
    public static final Type LOCK_TYPE = Type.getType(Lock.class);
    public static final Type STATISTICS_TYPE = Type.getType(Statistics.class);
    public static final Type DEPENDENCY_NODE_TYPE = Type.getType(DependencyNode.class);
    public static final String DUMMY_NODE_FIELD_NAME = "DUMMY_NODE";
    private final CacheDescriptor<T> descriptor;
    private final Cache staticInstance;
    private final Constructor<? extends Cache> constructor;
    private static final Map<Signature, Constructor> EMPTY_CACHE_IMPLEMENTATIONS = new THashMap();
    private static int id = 0;

    static synchronized Constructor<? extends Cache> getImplementation(Signature signature) {
        Signature erased = signature.erased();
        Constructor ctor = EMPTY_CACHE_IMPLEMENTATIONS.get(erased);
        if (ctor == null) {
            ctor = NullCacheManager.createImplementation(erased);
            EMPTY_CACHE_IMPLEMENTATIONS.put(erased, ctor);
        }
        return ctor;
    }

    private static synchronized Constructor createImplementation(Signature signature) {
        Type[] typeArray;
        Type[] typeArray2;
        String name = Type.getInternalName(NullCacheManager.class) + "$" + signature.getCacheInterface().getSimpleName() + "Impl$" + id++;
        Type cacheType = Type.getType(signature.getCacheInterface());
        ClassGenerator cw = new ClassGenerator(48, name, CodegenHelper.OBJECT_TYPE, cacheType);
        Type calculableType = Type.getType(signature.getCalculableInterface());
        MxField owner = cw.defineField(18, "owner", CodegenHelper.OBJECT_TYPE);
        MxField calculable = cw.defineField(18, "calculable", calculableType);
        Type valueType = Type.getType((Class)signature.getValue());
        MxConstructorGenerator ctor = cw.defineConstructor(1, CodegenHelper.OBJECT_TYPE, calculableType);
        ctor.callSuper();
        ctor.initFields(owner, calculable);
        ctor.returnValue();
        ctor.endMethod();
        Type keyType = signature.getContainerType();
        if (signature.getContainer() == null) {
            typeArray2 = CodegenHelper.EMPTY_TYPES;
        } else {
            Type[] typeArray3 = new Type[1];
            typeArray2 = typeArray3;
            typeArray3[0] = keyType;
        }
        MxGeneratorAdapter getOrCreate = cw.defineMethod(1, new Method("getOrCreate", valueType, typeArray2));
        getOrCreate.visitCode();
        getOrCreate.get(calculable);
        getOrCreate.get(owner);
        if (keyType != null) {
            getOrCreate.loadArg(0);
        }
        if (keyType == null) {
            Type[] typeArray4 = new Type[1];
            typeArray = typeArray4;
            typeArray4[0] = CodegenHelper.OBJECT_TYPE;
        } else {
            Type[] typeArray5 = new Type[2];
            typeArray5[0] = CodegenHelper.OBJECT_TYPE;
            typeArray = typeArray5;
            typeArray5[1] = keyType;
        }
        getOrCreate.invokeInterface(calculableType, new Method("calculate", valueType, typeArray));
        getOrCreate.returnValue();
        getOrCreate.endMethod();
        MxGeneratorAdapter getOwner = cw.defineMethod(1, new Method("getCacheOwner", CodegenHelper.OBJECT_TYPE, CodegenHelper.EMPTY_TYPES));
        getOwner.visitCode();
        getOwner.get(owner);
        getOwner.returnValue();
        getOwner.endMethod();
        MxGeneratorAdapter clear = cw.defineMethod(1, "clear", Type.VOID_TYPE, new Type[0]);
        clear.visitCode();
        clear.returnValue();
        clear.endMethod();
        MxGeneratorAdapter getLock = cw.defineMethod(1, "getLock", LOCK_TYPE, new Type[0]);
        getLock.visitCode();
        getLock.pushNull();
        getLock.returnValue();
        getLock.endMethod();
        MxGeneratorAdapter size = cw.defineMethod(1, "getSize", Type.INT_TYPE, new Type[0]);
        size.visitCode();
        size.push(0);
        size.returnValue();
        size.endMethod();
        MxGeneratorAdapter getStatistics = cw.defineMethod(1, "getStatistics", STATISTICS_TYPE, new Type[0]);
        getStatistics.visitCode();
        getStatistics.pushNull();
        getStatistics.returnValue();
        getStatistics.endMethod();
        MxGeneratorAdapter getDependencyNode = cw.defineMethod(1, "getDependencyNode", DEPENDENCY_NODE_TYPE, new Type[0]);
        getDependencyNode.visitCode();
        getDependencyNode.getStatic(Type.getType(DependencyTracker.class), DUMMY_NODE_FIELD_NAME, DEPENDENCY_NODE_TYPE);
        getDependencyNode.returnValue();
        getDependencyNode.endMethod();
        Class cls = cw.toClass(NullCacheManager.class.getClassLoader());
        try {
            return cls.getConstructor(Object.class, signature.getCalculableInterface());
        }
        catch (NoSuchMethodException e) {
            throw new MxCacheException(e);
        }
    }

    public NullCacheManager(CacheDescriptor<T> descriptor) {
        this.descriptor = descriptor;
        this.constructor = NullCacheManager.getImplementation(descriptor.getSignature());
        this.staticInstance = descriptor.isStatic() ? this.createCacheInstance(null) : null;
    }

    private Cache createCacheInstance(@Nullable T t) {
        try {
            return this.constructor.newInstance(t, this.descriptor.getCalculable());
        }
        catch (InstantiationException e) {
            throw new MxCacheException(e);
        }
        catch (IllegalAccessException e) {
            throw new MxCacheException(e);
        }
        catch (InvocationTargetException e) {
            throw new MxCacheException(e);
        }
    }

    @Override
    public CacheDescriptor<T> getDescriptor() {
        return this.descriptor;
    }

    @Override
    public Cache createCache(@Nullable T owner) {
        return this.staticInstance == null ? this.createCacheInstance(owner) : this.staticInstance;
    }

    @Override
    public String getImplementationDetails() {
        return "<cache disabled>";
    }

    @Override
    public CacheContext getContext() {
        return null;
    }
}

