/*
 * Decompiled with CFR 0.152.
 */
package com.maxifier.mxcache.impl;

import com.maxifier.mxcache.StatisticsModeEnum;
import com.maxifier.mxcache.caches.BooleanCalculatable;
import com.maxifier.mxcache.caches.ByteCalculatable;
import com.maxifier.mxcache.caches.Cache;
import com.maxifier.mxcache.caches.Calculable;
import com.maxifier.mxcache.caches.CharacterCalculatable;
import com.maxifier.mxcache.caches.CleaningNode;
import com.maxifier.mxcache.caches.DoubleCalculatable;
import com.maxifier.mxcache.caches.FloatCalculatable;
import com.maxifier.mxcache.caches.IntCalculatable;
import com.maxifier.mxcache.caches.LongCalculatable;
import com.maxifier.mxcache.caches.ObjectCalculatable;
import com.maxifier.mxcache.caches.ShortCalculatable;
import com.maxifier.mxcache.context.CacheContext;
import com.maxifier.mxcache.impl.AbstractCacheManager;
import com.maxifier.mxcache.impl.DefaultStorageFactory;
import com.maxifier.mxcache.impl.MutableStatistics;
import com.maxifier.mxcache.impl.caches.def.BooleanInlineCacheImpl;
import com.maxifier.mxcache.impl.caches.def.BooleanInlineDependencyCache;
import com.maxifier.mxcache.impl.caches.def.ByteInlineCacheImpl;
import com.maxifier.mxcache.impl.caches.def.ByteInlineDependencyCache;
import com.maxifier.mxcache.impl.caches.def.CharacterInlineCacheImpl;
import com.maxifier.mxcache.impl.caches.def.CharacterInlineDependencyCache;
import com.maxifier.mxcache.impl.caches.def.DoubleInlineCacheImpl;
import com.maxifier.mxcache.impl.caches.def.DoubleInlineDependencyCache;
import com.maxifier.mxcache.impl.caches.def.FloatInlineCacheImpl;
import com.maxifier.mxcache.impl.caches.def.FloatInlineDependencyCache;
import com.maxifier.mxcache.impl.caches.def.IntInlineCacheImpl;
import com.maxifier.mxcache.impl.caches.def.IntInlineDependencyCache;
import com.maxifier.mxcache.impl.caches.def.LongInlineCacheImpl;
import com.maxifier.mxcache.impl.caches.def.LongInlineDependencyCache;
import com.maxifier.mxcache.impl.caches.def.ObjectInlineCacheImpl;
import com.maxifier.mxcache.impl.caches.def.ObjectInlineDependencyCache;
import com.maxifier.mxcache.impl.caches.def.ShortInlineCacheImpl;
import com.maxifier.mxcache.impl.caches.def.ShortInlineDependencyCache;
import com.maxifier.mxcache.impl.resource.DependencyNode;
import com.maxifier.mxcache.impl.resource.DependencyNodeVisitor;
import com.maxifier.mxcache.impl.wrapping.WrapperFactory;
import com.maxifier.mxcache.impl.wrapping.Wrapping;
import com.maxifier.mxcache.interfaces.Statistics;
import com.maxifier.mxcache.interfaces.StatisticsHolder;
import com.maxifier.mxcache.provider.CacheDescriptor;
import com.maxifier.mxcache.provider.Signature;
import com.maxifier.mxcache.provider.StorageFactory;
import com.maxifier.mxcache.storage.CalculableInterceptor;
import com.maxifier.mxcache.storage.Storage;
import com.maxifier.mxcache.storage.elementlocked.ElementLockedStorage;
import com.maxifier.mxcache.util.TIdentityHashSet;
import java.lang.ref.Reference;
import javax.annotation.Nonnull;

public class StorageBasedCacheManager<T>
extends AbstractCacheManager<T> {
    public static final DependencyNode MARKER_NODE = new MarkerDependencyNode();
    private final StorageFactory<T> storageFactory;
    private final Signature cacheSignature;
    private WrapperFactory wrapperFactoryCache;
    private boolean elementLockedCache;
    private Signature storageSignatureCache;
    private boolean inlineCache;

    public StorageBasedCacheManager(CacheContext context, CacheDescriptor<T> descriptor, StorageFactory<T> storageFactory) {
        super(context, descriptor);
        this.storageFactory = storageFactory;
        this.cacheSignature = descriptor.getSignature();
        this.inlineCache = this.canInlineCache(descriptor, storageFactory);
    }

    private boolean canInlineCache(CacheDescriptor<T> descriptor, StorageFactory<T> storageFactory) {
        return storageFactory.getClass() == DefaultStorageFactory.class && descriptor.getSignature().getContainer() == null && !descriptor.isResourceView();
    }

    @Override
    @Nonnull
    protected Cache createCache(T owner, DependencyNode dependencyNode, MutableStatistics statistics) throws Exception {
        if (this.inlineCache) {
            if (dependencyNode == MARKER_NODE) {
                return this.createInlineCacheWithDependencyNode(owner, statistics);
            }
            Cache cache = this.createInlineCache(owner, statistics);
            cache.setDependencyNode(dependencyNode);
            return cache;
        }
        Storage storage = this.storageFactory.createStorage(owner);
        StatisticsModeEnum statisticsMode = this.getStatisticsMode();
        switch (statisticsMode) {
            case STORAGE: {
                statistics = (MutableStatistics)((StatisticsHolder)((Object)storage)).getStatistics();
                break;
            }
            case STATIC_OR_STORAGE: {
                Statistics storageStatistics;
                if (!(storage instanceof StatisticsHolder) || !((storageStatistics = ((StatisticsHolder)((Object)storage)).getStatistics()) instanceof MutableStatistics)) break;
                statistics = (MutableStatistics)storageStatistics;
            }
        }
        Calculable calculable = this.getDescriptor().getCalculable();
        if (storage instanceof CalculableInterceptor) {
            calculable = ((CalculableInterceptor)((Object)storage)).createInterceptedCalculable(calculable);
        }
        Cache cache = this.getWrapperFactory(storage instanceof ElementLockedStorage, Signature.ofStorage(storage.getClass())).wrap(owner, calculable, storage, statistics);
        cache.setDependencyNode(dependencyNode);
        return cache;
    }

    @Override
    protected DependencyNode createInstanceNode() {
        if (this.inlineCache) {
            return MARKER_NODE;
        }
        return super.createInstanceNode();
    }

    private Cache createInlineCache(T owner, MutableStatistics statistics) {
        assert (this.inlineCache);
        CacheDescriptor descriptor = this.getDescriptor();
        Class valueType = descriptor.getSignature().getValue();
        Calculable calculable = descriptor.getCalculable();
        if (valueType == Boolean.TYPE) {
            return new BooleanInlineCacheImpl(owner, (BooleanCalculatable)calculable, statistics);
        }
        if (valueType == Byte.TYPE) {
            return new ByteInlineCacheImpl(owner, (ByteCalculatable)calculable, statistics);
        }
        if (valueType == Short.TYPE) {
            return new ShortInlineCacheImpl(owner, (ShortCalculatable)calculable, statistics);
        }
        if (valueType == Character.TYPE) {
            return new CharacterInlineCacheImpl(owner, (CharacterCalculatable)calculable, statistics);
        }
        if (valueType == Integer.TYPE) {
            return new IntInlineCacheImpl(owner, (IntCalculatable)calculable, statistics);
        }
        if (valueType == Long.TYPE) {
            return new LongInlineCacheImpl(owner, (LongCalculatable)calculable, statistics);
        }
        if (valueType == Float.TYPE) {
            return new FloatInlineCacheImpl(owner, (FloatCalculatable)calculable, statistics);
        }
        if (valueType == Double.TYPE) {
            return new DoubleInlineCacheImpl(owner, (DoubleCalculatable)calculable, statistics);
        }
        return new ObjectInlineCacheImpl((Object)owner, (ObjectCalculatable)calculable, statistics);
    }

    private Cache createInlineCacheWithDependencyNode(T owner, MutableStatistics statistics) {
        assert (this.inlineCache);
        CacheDescriptor descriptor = this.getDescriptor();
        Class valueType = descriptor.getSignature().getValue();
        Calculable calculable = descriptor.getCalculable();
        if (valueType == Boolean.TYPE) {
            return new BooleanInlineDependencyCache(owner, (BooleanCalculatable)calculable, statistics);
        }
        if (valueType == Byte.TYPE) {
            return new ByteInlineDependencyCache(owner, (ByteCalculatable)calculable, statistics);
        }
        if (valueType == Short.TYPE) {
            return new ShortInlineDependencyCache(owner, (ShortCalculatable)calculable, statistics);
        }
        if (valueType == Character.TYPE) {
            return new CharacterInlineDependencyCache(owner, (CharacterCalculatable)calculable, statistics);
        }
        if (valueType == Integer.TYPE) {
            return new IntInlineDependencyCache(owner, (IntCalculatable)calculable, statistics);
        }
        if (valueType == Long.TYPE) {
            return new LongInlineDependencyCache(owner, (LongCalculatable)calculable, statistics);
        }
        if (valueType == Float.TYPE) {
            return new FloatInlineDependencyCache(owner, (FloatCalculatable)calculable, statistics);
        }
        if (valueType == Double.TYPE) {
            return new DoubleInlineDependencyCache(owner, (DoubleCalculatable)calculable, statistics);
        }
        return new ObjectInlineDependencyCache((Object)owner, (ObjectCalculatable)calculable, statistics);
    }

    private synchronized WrapperFactory getWrapperFactory(boolean elementLocked, Signature storageSignature) {
        if (this.wrapperFactoryCache == null || !storageSignature.equals(this.storageSignatureCache) || elementLocked != this.elementLockedCache) {
            this.wrapperFactoryCache = Wrapping.getFactory(storageSignature, this.cacheSignature, this.getDescriptor().getKeyTransform(), this.getDescriptor().getValueTransform(), elementLocked);
            this.storageSignatureCache = storageSignature;
            this.elementLockedCache = elementLocked;
        }
        return this.wrapperFactoryCache;
    }

    @Override
    public String getImplementationDetails() {
        return this.storageFactory.getImplementationDetails();
    }

    private static class MarkerDependencyNode
    implements DependencyNode {
        private MarkerDependencyNode() {
        }

        @Override
        public Reference<DependencyNode> getSelfReference() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void visitDependantNodes(DependencyNodeVisitor visitor) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void appendNodes(TIdentityHashSet<CleaningNode> elements) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void trackDependency(DependencyNode node) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addNode(@Nonnull CleaningNode cache) {
        }
    }
}

