/*
 * Decompiled with CFR 0.152.
 */
package com.maxifier.mxcache.impl.caches.abs;

import com.maxifier.mxcache.CacheFactory;
import com.maxifier.mxcache.caches.CharacterCache;
import com.maxifier.mxcache.caches.CharacterCalculatable;
import com.maxifier.mxcache.impl.CacheId;
import com.maxifier.mxcache.impl.CalculatableHelper;
import com.maxifier.mxcache.impl.MutableStatistics;
import com.maxifier.mxcache.impl.caches.abs.AbstractCache;
import com.maxifier.mxcache.impl.resource.DependencyNode;
import com.maxifier.mxcache.impl.resource.DependencyTracker;
import com.maxifier.mxcache.impl.resource.ResourceOccupied;
import com.maxifier.mxcache.provider.CacheDescriptor;
import com.maxifier.mxcache.storage.CharacterStorage;

public abstract class AbstractCharacterCache
extends AbstractCache
implements CharacterCache,
CharacterStorage {
    private final CharacterCalculatable calculatable;

    public AbstractCharacterCache(Object owner, CharacterCalculatable calculatable, MutableStatistics statistics) {
        super(owner, statistics);
        this.calculatable = calculatable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public char getOrCreate() {
        if (DependencyTracker.isBypassCaches()) {
            return this.calculatable.calculate(this.owner);
        }
        this.lock();
        try {
            if (this.isCalculated()) {
                DependencyTracker.mark(this.getDependencyNode());
                this.hit();
                char c = this.load();
                return c;
            }
            DependencyNode callerNode = DependencyTracker.track(this.getDependencyNode());
            while (true) {
                char c;
                try {
                    c = this.create();
                }
                catch (ResourceOccupied e) {
                    block19: {
                        if (callerNode != null) {
                            throw e;
                        }
                        this.unlock();
                        try {
                            e.getResource().waitForEndOfModification();
                        }
                        finally {
                            this.lock();
                        }
                        if (!this.isCalculated()) break block19;
                        this.hit();
                        char c2 = this.load();
                        DependencyTracker.exit(callerNode);
                        this.unlock();
                        return c2;
                    }
                    continue;
                    {
                        catch (Throwable throwable) {
                            DependencyTracker.exit(callerNode);
                            throw throwable;
                        }
                    }
                }
                DependencyTracker.exit(callerNode);
                return c;
                break;
            }
        }
        finally {
            this.unlock();
        }
    }

    protected char create() {
        long start = System.nanoTime();
        char t = this.calculatable.calculate(this.owner);
        long end = System.nanoTime();
        this.miss(end - start);
        this.save(t);
        return t;
    }

    @Override
    public CacheDescriptor getDescriptor() {
        CacheId id = CalculatableHelper.getId(this.calculatable.getClass());
        return CacheFactory.getProvider().getDescriptor(id);
    }

    @Override
    public String toString() {
        return this.getDescriptor() + ": " + this.owner;
    }
}

