/*
 * Decompiled with CFR 0.152.
 */
package com.maxifier.mxcache.impl.caches.abs;

import com.maxifier.mxcache.CacheFactory;
import com.maxifier.mxcache.caches.IntCharacterCache;
import com.maxifier.mxcache.caches.IntCharacterCalculatable;
import com.maxifier.mxcache.impl.CacheId;
import com.maxifier.mxcache.impl.CalculatableHelper;
import com.maxifier.mxcache.impl.MutableStatistics;
import com.maxifier.mxcache.impl.caches.abs.AbstractCache;
import com.maxifier.mxcache.impl.resource.DependencyNode;
import com.maxifier.mxcache.impl.resource.DependencyTracker;
import com.maxifier.mxcache.impl.resource.ResourceOccupied;
import com.maxifier.mxcache.provider.CacheDescriptor;
import com.maxifier.mxcache.storage.IntCharacterStorage;

public abstract class AbstractIntCharacterCache
extends AbstractCache
implements IntCharacterCache,
IntCharacterStorage {
    private final IntCharacterCalculatable calculatable;

    public AbstractIntCharacterCache(Object owner, IntCharacterCalculatable calculatable, MutableStatistics statistics) {
        super(owner, statistics);
        this.calculatable = calculatable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public char getOrCreate(int o) {
        if (DependencyTracker.isBypassCaches()) {
            return this.calculatable.calculate(this.owner, o);
        }
        this.lock();
        try {
            if (this.isCalculated(o)) {
                DependencyTracker.mark(this.getDependencyNode());
                this.hit();
                char c = this.load(o);
                return c;
            }
            DependencyNode callerNode = DependencyTracker.track(this.getDependencyNode());
            while (true) {
                char c;
                try {
                    c = this.create(o);
                }
                catch (ResourceOccupied e) {
                    block19: {
                        if (callerNode != null) {
                            throw e;
                        }
                        this.unlock();
                        try {
                            e.getResource().waitForEndOfModification();
                        }
                        finally {
                            this.lock();
                        }
                        if (!this.isCalculated(o)) break block19;
                        this.hit();
                        char c2 = this.load(o);
                        DependencyTracker.exit(callerNode);
                        this.unlock();
                        return c2;
                    }
                    continue;
                    {
                        catch (Throwable throwable) {
                            DependencyTracker.exit(callerNode);
                            throw throwable;
                        }
                    }
                }
                DependencyTracker.exit(callerNode);
                return c;
                break;
            }
        }
        finally {
            this.unlock();
        }
    }

    protected char create(int o) {
        long start = System.nanoTime();
        char t = this.calculatable.calculate(this.owner, o);
        long end = System.nanoTime();
        this.miss(end - start);
        this.save(o, t);
        return t;
    }

    @Override
    public CacheDescriptor getDescriptor() {
        CacheId id = CalculatableHelper.getId(this.calculatable.getClass());
        return CacheFactory.getProvider().getDescriptor(id);
    }

    @Override
    public String toString() {
        return this.getDescriptor() + ": " + this.owner;
    }
}

