/*
 * Decompiled with CFR 0.152.
 */
package com.maxifier.mxcache.impl.caches.abs.elementlocked;

import com.maxifier.mxcache.caches.Cache;
import com.maxifier.mxcache.impl.MutableStatistics;
import com.maxifier.mxcache.impl.caches.abs.elementlocked.ElementLockedStorage;
import com.maxifier.mxcache.impl.resource.DependencyNode;
import com.maxifier.mxcache.interfaces.Statistics;
import java.util.concurrent.locks.Lock;

abstract class AbstractElementLockedCache
implements Cache,
ElementLockedStorage {
    protected final Object owner;
    private final MutableStatistics statistics;
    private DependencyNode node;

    protected AbstractElementLockedCache(Object owner, MutableStatistics statistics) {
        this.owner = owner;
        this.statistics = statistics;
    }

    @Override
    public void setDependencyNode(DependencyNode node) {
        this.node = node;
    }

    public void miss(long dt) {
        this.statistics.miss(dt);
    }

    public void hit() {
        this.statistics.hit();
    }

    @Override
    public Statistics getStatistics() {
        return this.statistics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getSize() {
        Lock lock = this.getLock();
        if (lock == null) {
            return this.size();
        }
        lock.lock();
        try {
            int n = this.size();
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public DependencyNode getDependencyNode() {
        return this.node;
    }

    @Override
    public Object getCacheOwner() {
        return this.owner;
    }
}

