/*
 * Decompiled with CFR 0.152.
 */
package com.maxifier.mxcache.impl.caches.abs.elementlocked;

import com.maxifier.mxcache.CacheFactory;
import com.maxifier.mxcache.caches.FloatByteCache;
import com.maxifier.mxcache.caches.FloatByteCalculatable;
import com.maxifier.mxcache.impl.CacheId;
import com.maxifier.mxcache.impl.CalculatableHelper;
import com.maxifier.mxcache.impl.MutableStatistics;
import com.maxifier.mxcache.impl.caches.abs.elementlocked.AbstractElementLockedCache;
import com.maxifier.mxcache.impl.resource.DependencyNode;
import com.maxifier.mxcache.impl.resource.DependencyTracker;
import com.maxifier.mxcache.impl.resource.ResourceOccupied;
import com.maxifier.mxcache.provider.CacheDescriptor;
import com.maxifier.mxcache.storage.elementlocked.FloatByteElementLockedStorage;

public abstract class AbstractFloatByteCache
extends AbstractElementLockedCache
implements FloatByteCache,
FloatByteElementLockedStorage {
    private final FloatByteCalculatable calculatable;

    public AbstractFloatByteCache(Object owner, FloatByteCalculatable calculatable, MutableStatistics statistics) {
        super(owner, statistics);
        this.calculatable = calculatable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public byte getOrCreate(float o) {
        if (DependencyTracker.isBypassCaches()) {
            return this.calculatable.calculate(this.owner, o);
        }
        this.lock(o);
        try {
            if (this.isCalculated(o)) {
                DependencyTracker.mark(this.getDependencyNode());
                this.hit();
                byte by = this.load(o);
                return by;
            }
            DependencyNode callerNode = DependencyTracker.track(this.getDependencyNode());
            while (true) {
                byte by;
                try {
                    by = this.create(o);
                }
                catch (ResourceOccupied e) {
                    block19: {
                        if (callerNode != null) {
                            throw e;
                        }
                        this.unlock(o);
                        try {
                            e.getResource().waitForEndOfModification();
                        }
                        finally {
                            this.lock(o);
                        }
                        if (!this.isCalculated(o)) break block19;
                        this.hit();
                        byte by2 = this.load(o);
                        DependencyTracker.exit(callerNode);
                        this.unlock(o);
                        return by2;
                    }
                    continue;
                    {
                        catch (Throwable throwable) {
                            DependencyTracker.exit(callerNode);
                            throw throwable;
                        }
                    }
                }
                DependencyTracker.exit(callerNode);
                return by;
                break;
            }
        }
        finally {
            this.unlock(o);
        }
    }

    protected byte create(float key) {
        long start = System.nanoTime();
        byte t = this.calculatable.calculate(this.owner, key);
        long end = System.nanoTime();
        this.miss(end - start);
        this.save(key, t);
        return t;
    }

    @Override
    public CacheDescriptor getDescriptor() {
        CacheId id = CalculatableHelper.getId(this.calculatable.getClass());
        return CacheFactory.getProvider().getDescriptor(id);
    }

    public String toString() {
        return this.getDescriptor() + ": " + this.owner;
    }
}

