/*
 * Decompiled with CFR 0.152.
 */
package com.maxifier.mxcache.impl.caches.abs.elementlocked;

import com.maxifier.mxcache.CacheFactory;
import com.maxifier.mxcache.caches.LongCache;
import com.maxifier.mxcache.caches.LongCalculatable;
import com.maxifier.mxcache.impl.CacheId;
import com.maxifier.mxcache.impl.CalculatableHelper;
import com.maxifier.mxcache.impl.MutableStatistics;
import com.maxifier.mxcache.impl.caches.abs.elementlocked.AbstractElementLockedCache;
import com.maxifier.mxcache.impl.resource.DependencyNode;
import com.maxifier.mxcache.impl.resource.DependencyTracker;
import com.maxifier.mxcache.impl.resource.ResourceOccupied;
import com.maxifier.mxcache.provider.CacheDescriptor;
import com.maxifier.mxcache.storage.elementlocked.LongElementLockedStorage;
import java.util.concurrent.locks.Lock;

public abstract class AbstractLongCache
extends AbstractElementLockedCache
implements LongCache,
LongElementLockedStorage {
    private final LongCalculatable calculatable;

    public AbstractLongCache(Object owner, LongCalculatable calculatable, MutableStatistics statistics) {
        super(owner, statistics);
        this.calculatable = calculatable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public long getOrCreate() {
        if (DependencyTracker.isBypassCaches()) {
            return this.calculatable.calculate(this.owner);
        }
        Lock lock = this.getLock();
        if (lock != null) {
            lock.lock();
        }
        try {
            if (this.isCalculated()) {
                DependencyTracker.mark(this.getDependencyNode());
                this.hit();
                long l = this.load();
                return l;
            }
            DependencyNode callerNode = DependencyTracker.track(this.getDependencyNode());
            while (true) {
                long l;
                try {
                    l = this.create();
                }
                catch (ResourceOccupied e) {
                    block24: {
                        if (callerNode != null) {
                            throw e;
                        }
                        if (lock != null) {
                            lock.unlock();
                        }
                        try {
                            e.getResource().waitForEndOfModification();
                        }
                        finally {
                            if (lock != null) {
                                lock.lock();
                            }
                        }
                        if (!this.isCalculated()) break block24;
                        this.hit();
                        long l2 = this.load();
                        DependencyTracker.exit(callerNode);
                        if (lock != null) {
                            lock.unlock();
                        }
                        return l2;
                    }
                    continue;
                    {
                        catch (Throwable throwable) {
                            DependencyTracker.exit(callerNode);
                            throw throwable;
                        }
                    }
                }
                DependencyTracker.exit(callerNode);
                return l;
                break;
            }
        }
        finally {
            if (lock != null) {
                lock.unlock();
            }
        }
    }

    protected long create() {
        long start = System.nanoTime();
        long t = this.calculatable.calculate(this.owner);
        long end = System.nanoTime();
        this.miss(end - start);
        this.save(t);
        return t;
    }

    @Override
    public CacheDescriptor getDescriptor() {
        CacheId id = CalculatableHelper.getId(this.calculatable.getClass());
        return CacheFactory.getProvider().getDescriptor(id);
    }

    public String toString() {
        return this.getDescriptor() + ": " + this.owner;
    }
}

