/*
 * Decompiled with CFR 0.152.
 */
package com.maxifier.mxcache.impl.caches.abs.elementlocked;

import com.maxifier.mxcache.CacheFactory;
import com.maxifier.mxcache.caches.LongDoubleCache;
import com.maxifier.mxcache.caches.LongDoubleCalculatable;
import com.maxifier.mxcache.impl.CacheId;
import com.maxifier.mxcache.impl.CalculatableHelper;
import com.maxifier.mxcache.impl.MutableStatistics;
import com.maxifier.mxcache.impl.caches.abs.elementlocked.AbstractElementLockedCache;
import com.maxifier.mxcache.impl.resource.DependencyNode;
import com.maxifier.mxcache.impl.resource.DependencyTracker;
import com.maxifier.mxcache.impl.resource.ResourceOccupied;
import com.maxifier.mxcache.provider.CacheDescriptor;
import com.maxifier.mxcache.storage.elementlocked.LongDoubleElementLockedStorage;

public abstract class AbstractLongDoubleCache
extends AbstractElementLockedCache
implements LongDoubleCache,
LongDoubleElementLockedStorage {
    private final LongDoubleCalculatable calculatable;

    public AbstractLongDoubleCache(Object owner, LongDoubleCalculatable calculatable, MutableStatistics statistics) {
        super(owner, statistics);
        this.calculatable = calculatable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public double getOrCreate(long o) {
        if (DependencyTracker.isBypassCaches()) {
            return this.calculatable.calculate(this.owner, o);
        }
        this.lock(o);
        try {
            if (this.isCalculated(o)) {
                DependencyTracker.mark(this.getDependencyNode());
                this.hit();
                double d = this.load(o);
                return d;
            }
            DependencyNode callerNode = DependencyTracker.track(this.getDependencyNode());
            while (true) {
                double d;
                try {
                    d = this.create(o);
                }
                catch (ResourceOccupied e) {
                    block19: {
                        if (callerNode != null) {
                            throw e;
                        }
                        this.unlock(o);
                        try {
                            e.getResource().waitForEndOfModification();
                        }
                        finally {
                            this.lock(o);
                        }
                        if (!this.isCalculated(o)) break block19;
                        this.hit();
                        double d2 = this.load(o);
                        DependencyTracker.exit(callerNode);
                        this.unlock(o);
                        return d2;
                    }
                    continue;
                    {
                        catch (Throwable throwable) {
                            DependencyTracker.exit(callerNode);
                            throw throwable;
                        }
                    }
                }
                DependencyTracker.exit(callerNode);
                return d;
                break;
            }
        }
        finally {
            this.unlock(o);
        }
    }

    protected double create(long key) {
        long start = System.nanoTime();
        double t = this.calculatable.calculate(this.owner, key);
        long end = System.nanoTime();
        this.miss(end - start);
        this.save(key, t);
        return t;
    }

    @Override
    public CacheDescriptor getDescriptor() {
        CacheId id = CalculatableHelper.getId(this.calculatable.getClass());
        return CacheFactory.getProvider().getDescriptor(id);
    }

    public String toString() {
        return this.getDescriptor() + ": " + this.owner;
    }
}

